/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.persistence.manager.OrderedUpdatesManager;
import org.infinispan.util.ByteString;

public class InvalidateVersionsCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 67;
    private Object[] keys;
    private int[] topologyIds;
    private long[] versions;
    private boolean removed;
    protected DataContainer dataContainer;
    protected OrderedUpdatesManager orderedUpdatesManager;

    public InvalidateVersionsCommand() {
        this(null);
    }

    public InvalidateVersionsCommand(ByteString cacheName) {
        super(cacheName);
    }

    public InvalidateVersionsCommand(ByteString cacheName, Object[] keys, int[] topologyIds, long[] versions, boolean removed) {
        super(cacheName);
        this.keys = keys;
        this.topologyIds = topologyIds;
        this.versions = versions;
        this.removed = removed;
    }

    public void init(DataContainer dataContainer, OrderedUpdatesManager orderedUpdatesManager) {
        this.dataContainer = dataContainer;
        this.orderedUpdatesManager = orderedUpdatesManager;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() {
        Object key;
        for (int i = 0; i < this.keys.length && (key = this.keys[i]) != null; ++i) {
            SimpleClusteredVersion version = new SimpleClusteredVersion(this.topologyIds[i], this.versions[i]);
            this.dataContainer.compute(key, (k, oldEntry, factory) -> {
                if (oldEntry == null) {
                    return null;
                }
                SimpleClusteredVersion localVersion = (SimpleClusteredVersion)oldEntry.getMetadata().version();
                InequalVersionComparisonResult result = localVersion.compareTo(version);
                if (result == InequalVersionComparisonResult.BEFORE || this.removed && result == InequalVersionComparisonResult.EQUAL) {
                    return null;
                }
                return oldEntry;
            });
        }
        return this.orderedUpdatesManager.invalidate(this.keys).thenApply(nil -> null);
    }

    @Override
    public byte getCommandId() {
        return 67;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) {
                output.writeObject(null);
                break;
            }
            output.writeObject(this.keys[i]);
            output.writeInt(this.topologyIds[i]);
            output.writeLong(this.versions[i]);
        }
        output.writeBoolean(this.removed);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key;
        this.keys = new Object[input.readInt()];
        this.topologyIds = new int[this.keys.length];
        this.versions = new long[this.keys.length];
        for (int i = 0; i < this.keys.length && (key = input.readObject()) != null; ++i) {
            this.keys[i] = key;
            this.topologyIds[i] = input.readInt();
            this.versions[i] = input.readLong();
        }
        this.removed = input.readBoolean();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InvalidateVersionsCommand{removed=").append(this.removed).append(": ");
        if (this.keys.length > 0 && this.keys[0] != null) {
            sb.append(this.keys[0]).append(" -> ").append(this.versions[0]);
        } else {
            sb.append("<no-keys>");
        }
        for (int i = 1; i < this.keys.length && this.keys[i] != null; ++i) {
            sb.append(", ").append(this.keys[i]).append(" -> ").append(this.versions[i]);
        }
        return sb.append("}").toString();
    }
}

