/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compat;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.EncodingUtils;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.EncoderRegistry;

public class BiFunctionMapper
implements BiFunction {
    private final Class<? extends Encoder> keyEncoderClass;
    private final Class<? extends Encoder> valueEncoderClass;
    private final Class<? extends Wrapper> keyWrapperClass;
    private final Class<? extends Wrapper> valueWrapperClass;
    private Encoder keyEncoder;
    private Encoder valueEncoder;
    private Wrapper keyWrapper;
    private Wrapper valueWrapper;
    private final BiFunction biFunction;

    @Inject
    public void injectDependencies(EncoderRegistry encoderRegistry) {
        this.keyEncoder = encoderRegistry.getEncoder(this.keyEncoderClass);
        this.valueEncoder = encoderRegistry.getEncoder(this.valueEncoderClass);
        this.keyWrapper = encoderRegistry.getWrapper(this.keyWrapperClass);
        this.valueWrapper = encoderRegistry.getWrapper(this.valueWrapperClass);
    }

    public BiFunctionMapper(BiFunction remappingFunction, Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        this.biFunction = remappingFunction;
        this.keyEncoderClass = keyEncoderClass;
        this.valueEncoderClass = valueEncoderClass;
        this.keyWrapperClass = keyWrapperClass;
        this.valueWrapperClass = valueWrapperClass;
    }

    public Object apply(Object k, Object v) {
        Object value;
        Object key = EncodingUtils.fromStorage(k, this.keyEncoder, this.keyWrapper);
        Object result = this.biFunction.apply(key, value = EncodingUtils.fromStorage(v, this.valueEncoder, this.valueWrapper));
        return result != null ? EncodingUtils.toStorage(result, this.valueEncoder, this.valueWrapper) : null;
    }

    public static class Externalizer
    implements AdvancedExternalizer<BiFunctionMapper> {
        @Override
        public Set<Class<? extends BiFunctionMapper>> getTypeClasses() {
            return Collections.singleton(BiFunctionMapper.class);
        }

        @Override
        public Integer getId() {
            return 126;
        }

        @Override
        public void writeObject(ObjectOutput output, BiFunctionMapper object) throws IOException {
            output.writeObject(object.biFunction);
            output.writeObject(object.keyEncoderClass);
            output.writeObject(object.valueEncoderClass);
            output.writeObject(object.keyWrapperClass);
            output.writeObject(object.valueWrapperClass);
        }

        @Override
        public BiFunctionMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new BiFunctionMapper((BiFunction)input.readObject(), (Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject());
        }
    }
}

