/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.Attribute;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;

public abstract class AbstractJdbcStoreConfigurationSerializer
extends AbstractStoreSerializer {
    protected void writeJdbcStoreAttributes(XMLExtendedStreamWriter writer, AbstractJdbcStoreConfiguration configuration) throws XMLStreamException {
        configuration.attributes().write(writer);
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, SimpleConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_CONNECTION);
        SerializeUtils.writeOptional(writer, Attribute.CONNECTION_URL, configuration.connectionUrl());
        SerializeUtils.writeOptional(writer, Attribute.DRIVER_CLASS, configuration.driverClass());
        SerializeUtils.writeOptional(writer, Attribute.USERNAME, configuration.username());
        SerializeUtils.writeOptional(writer, Attribute.PASSWORD, configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, PooledConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.CONNECTION_POOL);
        SerializeUtils.writeOptional(writer, Attribute.CONNECTION_URL, configuration.connectionUrl());
        SerializeUtils.writeOptional(writer, Attribute.DRIVER_CLASS, configuration.driverClass());
        SerializeUtils.writeOptional(writer, Attribute.USERNAME, configuration.username());
        SerializeUtils.writeOptional(writer, Attribute.PASSWORD, configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, ManagedConnectionFactoryConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.DATA_SOURCE);
        writer.writeAttribute(Attribute.JNDI_URL, configuration.jndiUrl());
        writer.writeEndElement();
    }

    protected void writeJDBCStoreConnection(XMLExtendedStreamWriter writer, AbstractJdbcStoreConfiguration configuration) throws XMLStreamException {
        ConnectionFactoryConfiguration cfc = configuration.connectionFactory();
        if (cfc instanceof SimpleConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (SimpleConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof PooledConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (PooledConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof ManagedConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (ManagedConnectionFactoryConfiguration)cfc);
        }
    }

    protected void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, TableManipulationConfiguration configuration) throws XMLStreamException {
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement(element);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.TABLE_NAME_PREFIX, Attribute.PREFIX);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.FETCH_SIZE, Attribute.FETCH_SIZE);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.CREATE_ON_START, Attribute.CREATE_ON_START);
        attributes.write((XMLStreamWriter)writer, TableManipulationConfiguration.DROP_ON_EXIT, Attribute.DROP_ON_EXIT);
        this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, attributes, TableManipulationConfiguration.ID_COLUMN_NAME, TableManipulationConfiguration.ID_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, attributes, TableManipulationConfiguration.DATA_COLUMN_NAME, TableManipulationConfiguration.DATA_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, attributes, TableManipulationConfiguration.TIMESTAMP_COLUMN_NAME, TableManipulationConfiguration.TIMESTAMP_COLUMN_TYPE);
        writer.writeEndElement();
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, AttributeSet attributes, AttributeDefinition<?> columnName, AttributeDefinition<?> columnType) throws XMLStreamException {
        writer.writeStartElement(element);
        attributes.write((XMLStreamWriter)writer, columnName, Attribute.NAME);
        attributes.write((XMLStreamWriter)writer, columnType, Attribute.TYPE);
        writer.writeEndElement();
    }
}

