/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (this.configuration.dataContainer().dataContainer() != null) {
            return (T)this.configuration.dataContainer().dataContainer();
        }
        int level = this.configuration.locking().concurrencyLevel();
        long thresholdSize = this.configuration.memory().size();
        if (thresholdSize < 0L) {
            if (this.configuration.memory().storageType() == StorageType.OFF_HEAP) {
                return (T)new OffHeapDataContainer(this.configuration.memory().addressCount());
            }
            return (T)DefaultDataContainer.unBoundedDataContainer(level);
        }
        DataContainer dataContainer = this.configuration.memory().storageType() == StorageType.OFF_HEAP ? new BoundedOffHeapDataContainer(this.configuration.memory().addressCount(), thresholdSize, this.configuration.memory().evictionType()) : DefaultDataContainer.boundedDataContainer(level, thresholdSize, this.configuration.memory().evictionType());
        this.configuration.eviction().attributes().attribute(EvictionConfiguration.SIZE).addListener((newSize, old) -> this.configuration.memory().size((Long)newSize.get()));
        this.configuration.memory().attributes().attribute(MemoryConfiguration.SIZE).addListener((newSize, old) -> dataContainer.resize((Long)newSize.get()));
        return (T)dataContainer;
    }
}

