/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.concurrent.ExecutorService;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;

class LocalCacheStatus {
    private final CacheJoinInfo joinInfo;
    private final CacheTopologyHandler handler;
    private final PartitionHandlingManager partitionHandlingManager;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private final LimitedExecutor topologyUpdatesExecutor;

    LocalCacheStatus(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler handler, PartitionHandlingManager phm, ExecutorService executor) {
        this.joinInfo = joinInfo;
        this.handler = handler;
        this.partitionHandlingManager = phm;
        this.topologyUpdatesExecutor = new LimitedExecutor("Topology-" + cacheName, executor, 1);
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public CacheTopologyHandler getHandler() {
        return this.handler;
    }

    public PartitionHandlingManager getPartitionHandlingManager() {
        return this.partitionHandlingManager;
    }

    CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    void setCurrentTopology(CacheTopology currentTopology) {
        this.currentTopology = currentTopology;
    }

    CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    void setStableTopology(CacheTopology stableTopology) {
        this.stableTopology = stableTopology;
        this.partitionHandlingManager.onTopologyUpdate(this.currentTopology);
    }

    LimitedExecutor getTopologyUpdatesExecutor() {
        return this.topologyUpdatesExecutor;
    }
}

