/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.NDC;

public class LimitedExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(LimitedExecutor.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String name;
    private final Executor executor;
    private final boolean blocking;
    private int availablePermits;
    private final Deque<Runnable> queue = new ArrayDeque<Runnable>();
    private final Runner runner = new Runner();

    public LimitedExecutor(String name, Executor executor, int maxConcurrentTasks) {
        this.name = name;
        this.executor = executor;
        this.availablePermits = maxConcurrentTasks;
        this.blocking = executor instanceof WithinThreadExecutor;
    }

    public void cancelQueuedTasks() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        if (this.blocking) {
            CompletableFuture f1 = new CompletableFuture();
            this.executeInternal(() -> {
                f1.complete(null);
                this.removePermit();
            });
            try {
                CompletableFutures.await(f1);
                command.run();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IllegalLifecycleStateException(ie);
            }
            catch (Exception e) {
                log.debug("Exception in blocking task", e);
            }
            finally {
                this.addPermit();
                this.tryExecute();
            }
            return;
        }
        this.executeInternal(command);
    }

    public void executeInternal(Runnable command) {
        this.lock.lock();
        try {
            this.queue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.tryExecute();
    }

    public void executeAsync(Supplier<CompletableFuture<Void>> command) {
        this.execute(() -> {
            CompletableFuture future = (CompletableFuture)command.get();
            if (!future.isDone()) {
                this.removePermit();
                future.whenComplete((BiConsumer)this.runner);
            }
        });
    }

    private void tryExecute() {
        boolean addRunner = false;
        this.lock.lock();
        try {
            if (this.availablePermits > 0) {
                --this.availablePermits;
                addRunner = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (addRunner) {
            this.executor.execute(this.runner);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTasks() {
        while (true) {
            Runnable runnable = null;
            this.lock.lock();
            try {
                if (this.availablePermits >= 0) {
                    runnable = this.queue.poll();
                }
                if (runnable == null) {
                    ++this.availablePermits;
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            try {
                NDC.push(this.name);
                runnable.run();
                continue;
            }
            catch (Throwable t) {
                log.error("Exception in task", t);
                continue;
            }
            finally {
                NDC.pop();
                continue;
            }
            break;
        }
    }

    private void removePermit() {
        this.lock.lock();
        try {
            --this.availablePermits;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addPermit() {
        this.lock.lock();
        try {
            ++this.availablePermits;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Runner
    implements Runnable,
    BiConsumer<Void, Throwable> {
        private Runner() {
        }

        @Override
        public void run() {
            LimitedExecutor.this.runTasks();
        }

        @Override
        public void accept(Void aVoid, Throwable throwable) {
            LimitedExecutor.this.addPermit();
            LimitedExecutor.this.tryExecute();
        }
    }
}

