/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class StreamSegmentResponseCommand<R>
extends StreamResponseCommand<R> {
    public static final byte COMMAND_ID = 49;
    protected Set<Integer> missedSegments;

    protected StreamSegmentResponseCommand() {
    }

    public StreamSegmentResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamSegmentResponseCommand(ByteString cacheName, Address origin, Object id, boolean complete, R response, Set<Integer> missedSegments) {
        super(cacheName, origin, id, complete, response);
        this.missedSegments = missedSegments;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.csm.receiveResponse(this.id, this.getOrigin(), this.complete, this.missedSegments, this.response);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 49;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeObject(this.id);
        output.writeBoolean(this.complete);
        output.writeObject(this.response);
        MarshallUtil.marshallCollection(this.missedSegments, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.id = input.readObject();
        this.complete = input.readBoolean();
        this.response = input.readObject();
        this.missedSegments = MarshallUtil.unmarshallCollectionUnbounded(input, HashSet::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

