/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.CheckTopologyAction;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.LockAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTotalOrderPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler
implements LockListener {
    private static final Log log = LogFactory.getLog(NonTotalOrderPerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private final CheckTopologyAction checkTopologyAction = new CheckTopologyAction(this);
    private LockManager lockManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private long lockTimeout;
    private boolean isLocking;

    @Inject
    public void inject(LockManager lockManager, ClusteringDependentLogic clusteringDependentLogic, Configuration configuration) {
        this.lockManager = lockManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.lockTimeout = configuration.locking().lockAcquisitionTimeout();
        this.isLocking = !configuration.clustering().cacheMode().isScattered();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (order == DeliverOrder.TOTAL) {
            this.unexpectedDeliverMode(command, order);
        }
        try {
            BlockingRunnable runnable;
            int commandTopologyId = NonTotalOrderPerCacheInboundInvocationHandler.extractCommandTopologyId(command);
            boolean onExecutorService = this.executeOnExecutorService(order, command);
            boolean sync = order.preserveOrder();
            switch (command.getCommandId()) {
                case 1: {
                    runnable = onExecutorService ? this.createReadyActionRunnable(command, reply, commandTopologyId, sync, this.createReadyAction(commandTopologyId, (SingleRpcCommand)command)) : this.createDefaultRunnable(command, reply, commandTopologyId, TopologyMode.WAIT_TX_DATA, sync);
                    break;
                }
                default: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, command.getCommandId() != 15, onExecutorService, sync);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    public void onEvent(LockState state) {
        this.remoteCommandsExecutor.checkForReadyTasks();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private ReadyAction createReadyAction(int topologyId, RemoteLockCommand command) {
        if (command.hasSkipLocking() || !this.isLocking) {
            return null;
        }
        Collection<?> keys = command.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = command.hasZeroLockAcquisition() ? 0L : this.lockTimeout;
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(command, topologyId, timeoutMillis), this.checkTopologyAction, new LockAction(this.lockManager, this.clusteringDependentLogic));
        action.registerListener();
        return action;
    }

    private ReadyAction createReadyAction(int topologyId, SingleRpcCommand singleRpcCommand) {
        ReplicableCommand command = singleRpcCommand.getCommand();
        return command instanceof RemoteLockCommand ? this.createReadyAction(topologyId, (RemoteLockCommand)command) : null;
    }
}

