/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.persistence.remote.configuration.AbstractRemoteStoreConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfigurationBuilder;

public class SecurityConfigurationBuilder
extends AbstractRemoteStoreConfigurationChildBuilder
implements Builder<SecurityConfiguration> {
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final SslConfigurationBuilder ssl = new SslConfigurationBuilder(this);

    SecurityConfigurationBuilder(RemoteStoreConfigurationBuilder builder) {
        super(builder, null);
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    @Override
    public SecurityConfiguration create() {
        return new SecurityConfiguration(this.authentication.create(), this.ssl.create());
    }

    @Override
    public Builder<?> read(SecurityConfiguration template) {
        this.authentication.read(template.authentication());
        this.ssl.read(template.ssl());
        return this;
    }

    @Override
    public void validate() {
        this.authentication.validate();
        this.ssl.validate();
    }

    public String toString() {
        return "SecurityConfigurationBuilder{authentication=" + this.authentication + ", ssl=" + this.ssl + '}';
    }
}

