/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheManagerAdminImpl;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.uberjar.ManifestUberJarDuplicatedJarsWarner;

public class RemoteCacheManager
implements RemoteCacheContainer {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String DEFAULT_CACHE_NAME = "___defaultcache";
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    private volatile boolean started = false;
    private final Map<RemoteCacheKey, RemoteCacheHolder> cacheName2RemoteCache = new HashMap<RemoteCacheKey, RemoteCacheHolder>();
    private final AtomicInteger defaultCacheTopologyId = new AtomicInteger(-1);
    private Configuration configuration;
    private Codec codec;
    private Marshaller marshaller;
    protected TransportFactory transportFactory;
    private ExecutorService asyncExecutorService;
    protected ClientListenerNotifier listenerNotifier;
    private final Runnable start = this::start;
    private final Runnable stop = this::stop;

    public RemoteCacheManager(Configuration configuration) {
        this(configuration, true);
    }

    public RemoteCacheManager(Configuration configuration, boolean start) {
        this.configuration = configuration;
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        builder.classLoader(cl);
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, cl);
        if (stream == null) {
            log.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
        } else {
            try {
                builder.withProperties(this.loadFromStream(stream));
            }
            finally {
                Util.close((Closeable)stream);
            }
        }
        this.configuration = builder.build();
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.configuration.forceReturnValues());
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        return this.createRemoteCache(cacheName, forceReturnValue);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.configuration.forceReturnValues());
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(boolean forceReturnValue) {
        return this.createRemoteCache("", forceReturnValue);
    }

    public CompletableFuture<Void> startAsync() {
        this.createExecutorService();
        return CompletableFuture.runAsync(this.start, this.asyncExecutorService);
    }

    public CompletableFuture<Void> stopAsync() {
        this.createExecutorService();
        return CompletableFuture.runAsync(this.stop, this.asyncExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.transportFactory = Util.getInstance(this.configuration.transportFactory());
        if (this.marshaller == null) {
            this.marshaller = this.configuration.marshaller();
            if (this.marshaller == null) {
                Class<? extends Marshaller> clazz = this.configuration.marshallerClass();
                this.marshaller = clazz == GenericJBossMarshaller.class && !this.configuration.serialWhitelist().isEmpty() ? new GenericJBossMarshaller(this.configuration.serialWhitelist()) : Util.getInstance(clazz);
            }
        }
        this.codec = CodecFactory.getCodec(this.configuration.version());
        this.createExecutorService();
        this.listenerNotifier = ClientListenerNotifier.create(this.codec, this.marshaller, this.transportFactory, this.configuration.serialWhitelist());
        this.transportFactory.start(this.codec, this.configuration, this.defaultCacheTopologyId, this.listenerNotifier);
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (RemoteCacheHolder rcc : this.cacheName2RemoteCache.values()) {
                this.startRemoteCache(rcc);
            }
        }
        log.version(RemoteCacheManager.class.getPackage().getImplementationVersion());
        this.warnAboutUberJarDuplicates();
        this.started = true;
    }

    private void createExecutorService() {
        if (this.asyncExecutorService == null) {
            ExecutorFactory executorFactory = this.configuration.asyncExecutorFactory().factory();
            if (executorFactory == null) {
                executorFactory = Util.getInstance(this.configuration.asyncExecutorFactory().factoryClass());
            }
            this.asyncExecutorService = executorFactory.getExecutor(this.configuration.asyncExecutorFactory().properties());
        }
    }

    private final void warnAboutUberJarDuplicates() {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner();
        scanner.isClasspathCorrectAsync().thenAcceptAsync(isClasspathCorrect -> {
            if (!isClasspathCorrect.booleanValue()) {
                log.warnAboutUberJarDuplicates();
            }
        });
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.listenerNotifier.stop();
            this.transportFactory.destroy();
            this.asyncExecutorService.shutdownNow();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean switchToCluster(String clusterName) {
        return this.transportFactory.switchToCluster(clusterName);
    }

    @Override
    public boolean switchToDefaultCluster() {
        return this.transportFactory.switchToCluster("___DEFAULT-CLUSTER___");
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, Boolean forceReturnValueOverride) {
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValueOverride);
            if (!this.cacheName2RemoteCache.containsKey(key)) {
                RemoteCacheImpl<K, V> result = this.createRemoteCache(cacheName);
                RemoteCacheHolder rcc = new RemoteCacheHolder(result, forceReturnValueOverride == null ? this.configuration.forceReturnValues() : forceReturnValueOverride.booleanValue());
                this.startRemoteCache(rcc);
                PingOperation.PingResult pingResult = result.resolveCompatibility();
                if (!cacheName.equals(DEFAULT_CACHE_NAME) && pingResult == PingOperation.PingResult.CACHE_DOES_NOT_EXIST) {
                    return null;
                }
                result.start();
                this.cacheName2RemoteCache.put(key, rcc);
                return result;
            }
            return this.cacheName2RemoteCache.get((Object)key).remoteCache;
        }
    }

    private <K, V> RemoteCacheImpl<K, V> createRemoteCache(String cacheName) {
        switch (this.configuration.nearCache().mode()) {
            case INVALIDATED: {
                return new InvalidatedNearRemoteCache<K, V>(this, cacheName, this.createNearCacheService(this.configuration.nearCache()));
            }
        }
        return new RemoteCacheImpl(this, cacheName);
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    private void startRemoteCache(RemoteCacheHolder remoteCacheHolder) {
        RemoteCacheImpl<?, ?> remoteCache = remoteCacheHolder.remoteCache;
        OperationsFactory operationsFactory = new OperationsFactory(this.transportFactory, remoteCache.getName(), remoteCacheHolder.forceReturnValue, this.codec, this.listenerNotifier, this.asyncExecutorService, this.configuration);
        remoteCache.init(this.marshaller, this.asyncExecutorService, operationsFactory, this.configuration.keySizeEstimate(), this.configuration.valueSizeEstimate(), this.configuration.batchSize());
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.equals(DEFAULT_CACHE_NAME) ? HotRodConstants.DEFAULT_CACHE_NAME_BYTES : cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }

    public RemoteCacheManagerAdmin administration() {
        OperationsFactory operationsFactory = new OperationsFactory(this.transportFactory, this.codec, this.asyncExecutorService, this.configuration);
        return new RemoteCacheManagerAdminImpl(operationsFactory);
    }

    private static class RemoteCacheHolder {
        final RemoteCacheImpl<?, ?> remoteCache;
        final boolean forceReturnValue;

        RemoteCacheHolder(RemoteCacheImpl<?, ?> remoteCache, boolean forceReturnValue) {
            this.remoteCache = remoteCache;
            this.forceReturnValue = forceReturnValue;
        }
    }

    private static class RemoteCacheKey {
        final String cacheName;
        final boolean forceReturnValue;

        RemoteCacheKey(String cacheName, boolean forceReturnValue) {
            this.cacheName = cacheName;
            this.forceReturnValue = forceReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RemoteCacheKey)) {
                return false;
            }
            RemoteCacheKey that = (RemoteCacheKey)o;
            if (this.forceReturnValue != that.forceReturnValue) {
                return false;
            }
            return !(this.cacheName == null ? that.cacheName != null : !this.cacheName.equals(that.cacheName));
        }

        public int hashCode() {
            int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
            result = 31 * result + (this.forceReturnValue ? 1 : 0);
            return result;
        }
    }
}

