/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import javax.naming.NamingException;
import javax.transaction.SystemException;
import org.hibernate.cache.CacheException;
import org.infinispan.util.ByteString;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HHH")
public interface InfinispanMessageLogger
extends BasicLogger {
    @Message(value="Pending-puts cache must not be clustered!", id=25001)
    public CacheException pendingPutsMustNotBeClustered();

    @Message(value="Pending-puts cache must not be transactional!", id=25002)
    public CacheException pendingPutsMustNotBeTransactional();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Pending-puts cache configuration should be a template.", id=25003)
    public void pendingPutsShouldBeTemplate();

    @Message(value="Pending-puts cache must have expiration.max-idle set", id=25004)
    public CacheException pendingPutsMustHaveMaxIdle();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property 'hibernate.cache.infinispan.use_synchronization' is deprecated; 2LC with transactional cache must always use synchronizations.", id=25005)
    public void propertyUseSynchronizationDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Custom cache configuration '%s' was requested for type %s but it was not found!", id=25006)
    public void customConfigForTypeNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Custom cache configuration '%s' was requested for region %s but it was not found - using configuration by type (%s).", id=25007)
    public void customConfigForRegionNotFound(String var1, String var2, String var3);

    @Message(value="Timestamps cache must not use eviction!", id=25008)
    public CacheException timestampsMustNotUseEviction();

    @Message(value="Unable to start region factory", id=25009)
    public CacheException unableToStart(@Cause Throwable var1);

    @Message(value="Unable to create default cache manager", id=25010)
    public CacheException unableToCreateCacheManager(@Cause Throwable var1);

    @Message(value="Infinispan custom cache command factory not installed (possibly because the classloader where Infinispan lives couldn't find the Hibernate Infinispan cache provider)", id=25011)
    public CacheException cannotInstallCommandFactory();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Requesting TRANSACTIONAL cache concurrency strategy but the cache is not configured as transactional.", id=25012)
    public void transactionalStrategyNonTransactionalCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Requesting READ_WRITE cache concurrency strategy but the cache was configured as transactional.", id=25013)
    public void readWriteStrategyTransactionalCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Setting eviction on cache using tombstones can introduce inconsistencies!", id=25014)
    public void evictionWithTombstones();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failure updating cache in afterCompletion, will retry", id=25015)
    public void failureInAfterCompletion(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to end invalidating pending putFromLoad calls for key %s from region %s; the key won't be cached until invalidation expires.", id=25016)
    public void failedEndInvalidating(Object var1, ByteString var2);

    @Message(value="Unable to retrieve CacheManager from JNDI [%s]", id=25017)
    public CacheException unableToRetrieveCmFromJndi(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to release initial context", id=25018)
    public void unableToReleaseContext(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Use non-transactional query caches for best performance!", id=25019)
    public void useNonTransactionalQueryCache();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to broadcast invalidations as a part of the prepare phase. Rolling back.", id=25020)
    public void unableToRollbackInvalidationsDuringPrepare(@Cause Throwable var1);

    @Message(value="Could not suspend transaction", id=25021)
    public CacheException cannotSuspendTx(@Cause SystemException var1);

    @Message(value="Could not resume transaction", id=25022)
    public CacheException cannotResumeTx(@Cause Exception var1);

    @Message(value="Unable to get current transaction", id=25023)
    public CacheException cannotGetCurrentTx(@Cause SystemException var1);

    @Message(value="Failed to invalidate pending putFromLoad calls for key %s from region %s", id=25024)
    public CacheException failedInvalidatePendingPut(Object var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to invalidate pending putFromLoad calls for region %s", id=25025)
    public void failedInvalidateRegion(String var1);

    @Message(value="Property 'hibernate.cache.infinispan.cachemanager' not set", id=25026)
    public CacheException propertyCacheManagerResourceNotSet();

    @Message(value="Timestamp cache cannot be configured with invalidation", id=25027)
    public CacheException timestampsMustNotUseInvalidation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring deprecated property '%s'", id=25028)
    public void ignoringDeprecatedProperty(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property '%s' is deprecated, please use '%s' instead", id=25029)
    public void deprecatedProperty(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Transactional caches are not supported. The configuration option will be ignored; please unset.", id=25030)
    public void transactionalConfigurationIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration for pending-puts cache '%s' is already defined - another instance of SessionFactory was not closed properly.", id=25031)
    public void pendingPutsCacheAlreadyDefined(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache configuration '%s' is present but the use has not been defined through hibernate.cache.infinispan.%s.cfg=%s", id=25032)
    public void regionNameMatchesCacheName(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration properties contain record for unqualified region name '%s' but it should contain qualified region name '%s'", id=25033)
    public void usingUnqualifiedNameInConfiguration(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration for unqualified region name '%s' is defined but the cache will use qualified name '%s'", id=25034)
    public void configurationWithUnqualifiedName(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Operation #%d scheduled to complete before transaction completion failed", id=25035)
    public void failureBeforeTransactionCompletion(int var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Operation #%d scheduled after transaction completion failed (transaction successful? %s)", id=25036)
    public void failureAfterTransactionCompletion(int var1, boolean var2, @Cause Exception var3);

    public static class Provider {
        public static InfinispanMessageLogger getLog(Class clazz) {
            return (InfinispanMessageLogger)Logger.getMessageLogger(InfinispanMessageLogger.class, (String)clazz.getName());
        }
    }
}

