/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.Ownership;
import org.infinispan.hibernate.cache.commons.util.CompletableFunction;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingInterceptor
extends NonTransactionalLockingInterceptor {
    private static final Log log = LogFactory.getLog(LockingInterceptor.class);
    protected final InvocationFinallyFunction<DataWriteCommand> unlockAllReturnCheckCompletableFutureHandler = (rCtx, rCommand, rv, throwable) -> {
        this.lockManager.unlockAll(rCtx);
        if (throwable != null) {
            throw throwable;
        }
        if (rv instanceof CompletableFuture) {
            Function function;
            if (rCommand instanceof ReadWriteKeyCommand && (function = ((ReadWriteKeyCommand)rCommand).getFunction()) instanceof CompletableFunction) {
                ((CompletableFunction)((Object)function)).markComplete();
            }
            rCommand.setFlagsBitSet(rCommand.getFlagsBitSet() & (FlagBitSets.FORCE_WRITE_LOCK ^ 0xFFFFFFFFFFFFFFFFL));
            return LockingInterceptor.asyncValue((CompletionStage)((CompletableFuture)rv));
        }
        return rv;
    };
    protected final InvocationFinallyFunction<DataWriteCommand> invokeNextAndUnlock = (rCtx, dataWriteCommand, rv, throwable) -> {
        if (throwable != null) {
            this.lockManager.unlockAll(rCtx);
            if (throwable instanceof TimeoutException && dataWriteCommand.hasAnyFlag(FlagBitSets.FAIL_SILENTLY)) {
                dataWriteCommand.fail();
                return null;
            }
            throw throwable;
        }
        return this.invokeNextAndHandle(rCtx, dataWriteCommand, this.unlockAllReturnCheckCompletableFutureHandler);
    };

    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        try {
            if (log.isTraceEnabled()) {
                Ownership ownership = this.cdl.getCacheTopology().getDistribution(command.getKey()).writeOwnership();
                log.tracef("Am I owner for key=%s ? %s", command.getKey(), (Object)ownership);
            }
            if (ctx.getLockOwner() == null) {
                ctx.setLockOwner((Object)command.getCommandInvocationId());
            }
            InvocationStage lockStage = this.lockAndRecord(ctx, (VisitableCommand)command, command.getKey(), this.getLockTimeoutMillis((FlagAffectedCommand)command));
            return lockStage.andHandle(ctx, (VisitableCommand)command, this.invokeNextAndUnlock);
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
    }
}

