/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class TxPutFromLoadInterceptor
extends BaseRpcInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TxPutFromLoadInterceptor.class);
    private static final Log ispnLog = LogFactory.getLog(TxPutFromLoadInterceptor.class);
    private final PutFromLoadValidator putFromLoadValidator;
    private final ByteString cacheName;
    @Inject
    RpcManager rpcManager;
    @Inject
    InternalDataContainer dataContainer;
    @Inject
    DistributionManager distributionManager;

    public TxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, ByteString cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    private void beginInvalidating(InvocationContext ctx, Object key) {
        TxInvocationContext txCtx = (TxInvocationContext)ctx;
        txCtx.addAffectedKey(key);
        GlobalTransaction globalTransaction = txCtx.getGlobalTransaction();
        if (!this.putFromLoadValidator.beginInvalidatingKey(globalTransaction, key)) {
            throw log.failedInvalidatePendingPut(key, this.cacheName.toString());
        }
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (!command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            this.beginInvalidating(ctx, command.getKey());
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        this.beginInvalidating(ctx, command.getKey());
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (ctx.isOriginLocal()) {
            for (WriteCommand wc : command.getModifications()) {
                for (Object key : wc.getAffectedKeys()) {
                    this.dataContainer.remove(key);
                }
            }
        } else {
            for (WriteCommand wc : command.getModifications()) {
                Collection keys = wc.getAffectedKeys();
                if (log.isTraceEnabled()) {
                    log.tracef("Invalidating keys %s with lock owner %s", keys, ctx.getLockOwner());
                }
                for (Object key : keys) {
                    this.putFromLoadValidator.beginInvalidatingKey(ctx.getLockOwner(), key);
                }
            }
        }
        return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        if (log.isTraceEnabled()) {
            log.tracef("Commit command received, end invalidation", new Object[0]);
        }
        return this.endInvalidationAndInvokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
        if (log.isTraceEnabled()) {
            log.tracef("Rollback command received, end invalidation", new Object[0]);
        }
        return this.endInvalidationAndInvokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    protected Object endInvalidationAndInvokeNextInterceptor(TxInvocationContext<?> ctx, VisitableCommand command) {
        if (ctx.isOriginLocal() && !ctx.getModifications().isEmpty()) {
            Object[] keys = ctx.getModifications().stream().flatMap(mod -> mod.getAffectedKeys().stream()).distinct().toArray();
            if (log.isTraceEnabled()) {
                log.tracef("Sending end invalidation for keys %s asynchronously, modifications are %s", Arrays.toString(keys), ctx.getCacheTransaction().getModifications());
            }
            GlobalTransaction globalTransaction = ctx.getGlobalTransaction();
            EndInvalidationCommand commitCommand = new EndInvalidationCommand(this.cacheName, keys, globalTransaction);
            List members = this.distributionManager.getCacheTopology().getMembers();
            this.rpcManager.sendToMany((Collection)members, (ReplicableCommand)commitCommand, DeliverOrder.NONE);
            for (Object key : keys) {
                this.putFromLoadValidator.endInvalidatingKey(globalTransaction, key);
            }
        }
        return this.invokeNext((InvocationContext)ctx, command);
    }

    protected Log getLog() {
        return ispnLog;
    }
}

