package org.infinispan.hibernate.cache.commons.util;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.hibernate.cache.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.util.ByteString;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import jakarta.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-03-18T12:01:22-0400")
public class InfinispanMessageLogger_$logger extends DelegatingBasicLogger implements InfinispanMessageLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanMessageLogger_$logger.class.getName();
    public InfinispanMessageLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String pendingPutsMustNotBeClustered$str() {
        return "HHH025001: Pending-puts cache must not be clustered!";
    }
    @Override
    public final CacheException pendingPutsMustNotBeClustered() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustNotBeClustered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String pendingPutsMustNotBeTransactional$str() {
        return "HHH025002: Pending-puts cache must not be transactional!";
    }
    @Override
    public final CacheException pendingPutsMustNotBeTransactional() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustNotBeTransactional$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void pendingPutsShouldBeTemplate() {
        super.log.logf(FQCN, WARN, null, pendingPutsShouldBeTemplate$str());
    }
    protected String pendingPutsShouldBeTemplate$str() {
        return "HHH025003: Pending-puts cache configuration should be a template.";
    }
    protected String pendingPutsMustHaveMaxIdle$str() {
        return "HHH025004: Pending-puts cache must have expiration.max-idle set";
    }
    @Override
    public final CacheException pendingPutsMustHaveMaxIdle() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustHaveMaxIdle$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void propertyUseSynchronizationDeprecated() {
        super.log.logf(FQCN, WARN, null, propertyUseSynchronizationDeprecated$str());
    }
    protected String propertyUseSynchronizationDeprecated$str() {
        return "HHH025005: Property 'hibernate.cache.infinispan.use_synchronization' is deprecated; 2LC with transactional cache must always use synchronizations.";
    }
    @Override
    public final void customConfigForTypeNotFound(final String cacheName, final String type) {
        super.log.logf(FQCN, ERROR, null, customConfigForTypeNotFound$str(), cacheName, type);
    }
    protected String customConfigForTypeNotFound$str() {
        return "HHH025006: Custom cache configuration '%s' was requested for type %s but it was not found!";
    }
    @Override
    public final void customConfigForRegionNotFound(final String templateCacheName, final String regionName, final String type) {
        super.log.logf(FQCN, ERROR, null, customConfigForRegionNotFound$str(), templateCacheName, regionName, type);
    }
    protected String customConfigForRegionNotFound$str() {
        return "HHH025007: Custom cache configuration '%s' was requested for region %s but it was not found - using configuration by type (%s).";
    }
    protected String timestampsMustNotUseEviction$str() {
        return "HHH025008: Timestamps cache must not use eviction!";
    }
    @Override
    public final CacheException timestampsMustNotUseEviction() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), timestampsMustNotUseEviction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToStart$str() {
        return "HHH025009: Unable to start region factory";
    }
    @Override
    public final CacheException unableToStart(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToStart$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateCacheManager$str() {
        return "HHH025010: Unable to create default cache manager";
    }
    @Override
    public final CacheException unableToCreateCacheManager(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToCreateCacheManager$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstallCommandFactory$str() {
        return "HHH025011: Infinispan custom cache command factory not installed (possibly because the classloader where Infinispan lives couldn't find the Hibernate Infinispan cache provider)";
    }
    @Override
    public final CacheException cannotInstallCommandFactory() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotInstallCommandFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void transactionalStrategyNonTransactionalCache() {
        super.log.logf(FQCN, WARN, null, transactionalStrategyNonTransactionalCache$str());
    }
    protected String transactionalStrategyNonTransactionalCache$str() {
        return "HHH025012: Requesting TRANSACTIONAL cache concurrency strategy but the cache is not configured as transactional.";
    }
    @Override
    public final void readWriteStrategyTransactionalCache() {
        super.log.logf(FQCN, WARN, null, readWriteStrategyTransactionalCache$str());
    }
    protected String readWriteStrategyTransactionalCache$str() {
        return "HHH025013: Requesting READ_WRITE cache concurrency strategy but the cache was configured as transactional.";
    }
    @Override
    public final void evictionWithTombstones() {
        super.log.logf(FQCN, WARN, null, evictionWithTombstones$str());
    }
    protected String evictionWithTombstones$str() {
        return "HHH025014: Setting eviction on cache using tombstones can introduce inconsistencies!";
    }
    @Override
    public final void failureInAfterCompletion(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failureInAfterCompletion$str());
    }
    protected String failureInAfterCompletion$str() {
        return "HHH025015: Failure updating cache in afterCompletion, will retry";
    }
    @Override
    public final void failedEndInvalidating(final Object key, final ByteString name) {
        super.log.logf(FQCN, ERROR, null, failedEndInvalidating$str(), key, name);
    }
    protected String failedEndInvalidating$str() {
        return "HHH025016: Failed to end invalidating pending putFromLoad calls for key %s from region %s; the key won't be cached until invalidation expires.";
    }
    protected String unableToRetrieveCmFromJndi$str() {
        return "HHH025017: Unable to retrieve CacheManager from JNDI [%s]";
    }
    @Override
    public final CacheException unableToRetrieveCmFromJndi(final String jndiNamespace) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToRetrieveCmFromJndi$str(), jndiNamespace));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToReleaseContext(final NamingException ne) {
        super.log.logf(FQCN, WARN, ne, unableToReleaseContext$str());
    }
    protected String unableToReleaseContext$str() {
        return "HHH025018: Unable to release initial context";
    }
    @Override
    public final void useNonTransactionalQueryCache() {
        super.log.logf(FQCN, WARN, null, useNonTransactionalQueryCache$str());
    }
    protected String useNonTransactionalQueryCache$str() {
        return "HHH025019: Use non-transactional query caches for best performance!";
    }
    @Override
    public final void unableToRollbackInvalidationsDuringPrepare(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToRollbackInvalidationsDuringPrepare$str());
    }
    protected String unableToRollbackInvalidationsDuringPrepare$str() {
        return "HHH025020: Unable to broadcast invalidations as a part of the prepare phase. Rolling back.";
    }
    protected String cannotSuspendTx$str() {
        return "HHH025021: Could not suspend transaction";
    }
    @Override
    public final CacheException cannotSuspendTx(final SystemException se) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotSuspendTx$str()), se);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResumeTx$str() {
        return "HHH025022: Could not resume transaction";
    }
    @Override
    public final CacheException cannotResumeTx(final Exception e) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotResumeTx$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGetCurrentTx$str() {
        return "HHH025023: Unable to get current transaction";
    }
    @Override
    public final CacheException cannotGetCurrentTx(final SystemException e) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotGetCurrentTx$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedInvalidatePendingPut$str() {
        return "HHH025024: Failed to invalidate pending putFromLoad calls for key %s from region %s";
    }
    @Override
    public final CacheException failedInvalidatePendingPut(final Object key, final String regionName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedInvalidatePendingPut$str(), key, regionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedInvalidateRegion(final String regionName) {
        super.log.logf(FQCN, ERROR, null, failedInvalidateRegion$str(), regionName);
    }
    protected String failedInvalidateRegion$str() {
        return "HHH025025: Failed to invalidate pending putFromLoad calls for region %s";
    }
    protected String propertyCacheManagerResourceNotSet$str() {
        return "HHH025026: Property 'hibernate.cache.infinispan.cachemanager' not set";
    }
    @Override
    public final CacheException propertyCacheManagerResourceNotSet() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), propertyCacheManagerResourceNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timestampsMustNotUseInvalidation$str() {
        return "HHH025027: Timestamp cache cannot be configured with invalidation";
    }
    @Override
    public final CacheException timestampsMustNotUseInvalidation() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), timestampsMustNotUseInvalidation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringDeprecatedProperty(final String deprecated) {
        super.log.logf(FQCN, WARN, null, ignoringDeprecatedProperty$str(), deprecated);
    }
    protected String ignoringDeprecatedProperty$str() {
        return "HHH025028: Ignoring deprecated property '%s'";
    }
    @Override
    public final void deprecatedProperty(final String deprecated, final String alternative) {
        super.log.logf(FQCN, WARN, null, deprecatedProperty$str(), deprecated, alternative);
    }
    protected String deprecatedProperty$str() {
        return "HHH025029: Property '%s' is deprecated, please use '%s' instead";
    }
    @Override
    public final void transactionalConfigurationIgnored() {
        super.log.logf(FQCN, WARN, null, transactionalConfigurationIgnored$str());
    }
    protected String transactionalConfigurationIgnored$str() {
        return "HHH025030: Transactional caches are not supported. The configuration option will be ignored; please unset.";
    }
    @Override
    public final void pendingPutsCacheAlreadyDefined(final String pendingPutsName) {
        super.log.logf(FQCN, WARN, null, pendingPutsCacheAlreadyDefined$str(), pendingPutsName);
    }
    protected String pendingPutsCacheAlreadyDefined$str() {
        return "HHH025031: Configuration for pending-puts cache '%s' is already defined - another instance of SessionFactory was not closed properly.";
    }
    @Override
    public final void regionNameMatchesCacheName(final String regionName, final String regionName2, final String regionName3) {
        super.log.logf(FQCN, WARN, null, regionNameMatchesCacheName$str(), regionName, regionName2, regionName3);
    }
    protected String regionNameMatchesCacheName$str() {
        return "HHH025032: Cache configuration '%s' is present but the use has not been defined through hibernate.cache.infinispan.%s.cfg=%s";
    }
    @Override
    public final void usingUnqualifiedNameInConfiguration(final String unqualifiedRegionName, final String cacheName) {
        super.log.logf(FQCN, WARN, null, usingUnqualifiedNameInConfiguration$str(), unqualifiedRegionName, cacheName);
    }
    protected String usingUnqualifiedNameInConfiguration$str() {
        return "HHH025033: Configuration properties contain record for unqualified region name '%s' but it should contain qualified region name '%s'";
    }
    @Override
    public final void configurationWithUnqualifiedName(final String unqualifiedRegionName, final String cacheName) {
        super.log.logf(FQCN, WARN, null, configurationWithUnqualifiedName$str(), unqualifiedRegionName, cacheName);
    }
    protected String configurationWithUnqualifiedName$str() {
        return "HHH025034: Configuration for unqualified region name '%s' is defined but the cache will use qualified name '%s'";
    }
    @Override
    public final void failureBeforeTransactionCompletion(final int index, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failureBeforeTransactionCompletion$str(), index);
    }
    protected String failureBeforeTransactionCompletion$str() {
        return "HHH025035: Operation #%d scheduled to complete before transaction completion failed";
    }
    @Override
    public final void failureAfterTransactionCompletion(final int index, final boolean successful, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failureAfterTransactionCompletion$str(), index, successful);
    }
    protected String failureAfterTransactionCompletion$str() {
        return "HHH025036: Operation #%d scheduled after transaction completion failed (transaction successful? %s)";
    }
}
