/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.timestamp;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.commons.impl.BaseGeneralDataRegion;
import org.infinispan.hibernate.cache.commons.util.Caches;

public abstract class TimestampsRegionImpl
extends BaseGeneralDataRegion {
    private final AdvancedCache removeCache;
    private final AdvancedCache timestampsPutCache;

    public TimestampsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        this.removeCache = Caches.ignoreReturnValuesCache(cache);
        this.timestampsPutCache = this.getTimestampsPutCache(cache);
    }

    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.ignoreReturnValuesCache(cache, Flag.SKIP_LOCKING);
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.removeCache.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
        }
        finally {
            this.resume(tx);
        }
    }

    public Object getItem(Object session, Object key) throws CacheException {
        if (this.checkValid()) {
            return this.cache.get(key);
        }
        return null;
    }

    public void putItem(Object session, Object key, Object value) throws CacheException {
        try {
            this.timestampsPutCache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

