/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import javax.transaction.Synchronization;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;

final class SessionThreadLocal {
    private final ThreadLocal<Object> currentSession = new ThreadLocal();
    private final SessionAccess sessionAccess = SessionAccess.findSessionAccess();

    public void setSession(Object session) {
        this.currentSession.set(session);
    }

    public void remove() {
        this.currentSession.remove();
    }

    Object getSession() {
        return this.currentSession.get();
    }

    public boolean hasTransactionCoordinator() {
        Object session = this.currentSession.get();
        return this.sessionAccess.getTransactionCoordinator(session) != null;
    }

    public void registerSynchronization(Synchronization sync) {
        Object session = this.currentSession.get();
        this.sessionAccess.getTransactionCoordinator(session).registerLocalSynchronization(sync);
    }
}

