/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.ServiceRegistry;
import org.infinispan.hibernate.cache.commons.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.manager.EmbeddedCacheManager;

public class JndiInfinispanRegionFactory
extends InfinispanRegionFactory {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(JndiInfinispanRegionFactory.class);
    public static final String CACHE_MANAGER_RESOURCE_PROP = "hibernate.cache.infinispan.cachemanager";

    public JndiInfinispanRegionFactory() {
    }

    public JndiInfinispanRegionFactory(Properties props) {
        super(props);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(Properties properties, ServiceRegistry serviceRegistry) throws CacheException {
        String name = ConfigurationHelper.getString((String)CACHE_MANAGER_RESOURCE_PROP, (Map)properties, null);
        if (name == null) {
            throw log.propertyCacheManagerResourceNotSet();
        }
        return this.locateCacheManager(name, JndiHelper.extractJndiProperties((Map)properties));
    }

    private EmbeddedCacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)ctx.lookup(jndiNamespace);
            return embeddedCacheManager;
        }
        catch (NamingException ne) {
            throw log.unableToRetrieveCmFromJndi(jndiNamespace);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.unableToReleaseContext(ne);
                }
            }
        }
    }

    @Override
    public void stop() {
    }
}

