/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;

public class TypeOverrides
implements Serializable {
    private final Set<String> overridden = new HashSet<String>();
    private String cacheName;
    private EvictionStrategy evictionStrategy;
    private long evictionWakeUpInterval;
    private int evictionMaxEntries;
    private long expirationLifespan;
    private long expirationMaxIdle;
    private boolean isExposeStatistics;

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Deprecated
    public EvictionStrategy getEvictionStrategy() {
        return this.evictionStrategy;
    }

    public void setEvictionStrategy(String evictionStrategy) {
        this.markAsOverriden("evictionStrategy");
        this.evictionStrategy = EvictionStrategy.valueOf((String)this.uc(evictionStrategy));
    }

    public long getEvictionWakeUpInterval() {
        return this.evictionWakeUpInterval;
    }

    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.markAsOverriden("evictionWakeUpInterval");
        this.evictionWakeUpInterval = evictionWakeUpInterval;
    }

    public int getEvictionMaxEntries() {
        return this.evictionMaxEntries;
    }

    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.markAsOverriden("evictionMaxEntries");
        this.evictionMaxEntries = evictionMaxEntries;
    }

    public long getExpirationLifespan() {
        return this.expirationLifespan;
    }

    public void setExpirationLifespan(long expirationLifespan) {
        this.markAsOverriden("expirationLifespan");
        this.expirationLifespan = expirationLifespan;
    }

    public long getExpirationMaxIdle() {
        return this.expirationMaxIdle;
    }

    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.markAsOverriden("expirationMaxIdle");
        this.expirationMaxIdle = expirationMaxIdle;
    }

    public boolean isExposeStatistics() {
        return this.isExposeStatistics;
    }

    public void setExposeStatistics(boolean isExposeStatistics) {
        this.markAsOverriden("isExposeStatistics");
        this.isExposeStatistics = isExposeStatistics;
    }

    public void applyTo(ConfigurationBuilder builder) {
        if (this.overridden.contains("evictionWakeUpInterval")) {
            builder.expiration().wakeUpInterval(this.evictionWakeUpInterval);
        }
        if (this.overridden.contains("evictionMaxEntries")) {
            builder.memory().size((long)this.evictionMaxEntries);
        }
        if (this.overridden.contains("expirationLifespan")) {
            builder.expiration().lifespan(this.expirationLifespan);
        }
        if (this.overridden.contains("expirationMaxIdle")) {
            builder.expiration().maxIdle(this.expirationMaxIdle);
        }
        if (this.overridden.contains("isExposeStatistics") && this.isExposeStatistics) {
            builder.jmxStatistics().enable();
        }
    }

    public void validateInfinispanConfiguration(Configuration cfg) throws CacheException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "cache=" + this.cacheName + ", strategy=" + this.evictionStrategy + ", wakeUpInterval=" + this.evictionWakeUpInterval + ", maxEntries=" + this.evictionMaxEntries + ", lifespan=" + this.expirationLifespan + ", maxIdle=" + this.expirationMaxIdle + '}';
    }

    private String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    private void markAsOverriden(String fieldName) {
        this.overridden.add(fieldName);
    }
}

