/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;

public class JndiCacheManagerProvider
implements EmbeddedCacheManagerProvider {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(JndiCacheManagerProvider.class);

    public EmbeddedCacheManager getEmbeddedCacheManager(Properties properties) {
        String jndiManagerName = properties.getProperty("hibernate.cache.infinispan.cachemanager");
        if (jndiManagerName != null) {
            EmbeddedCacheManager cacheManager = this.locateCacheManager(jndiManagerName, JndiHelper.extractJndiProperties((Map)properties));
            return new AbstractDelegatingEmbeddedCacheManager(cacheManager){

                public void stop() {
                }

                public void close() {
                }
            };
        }
        String factoryClass = properties.getProperty("hibernate.cache.region.factory_class");
        if (factoryClass.endsWith("JndiInfinispanRegionFactory") || factoryClass.equals("infinispan-jndi")) {
            throw log.propertyCacheManagerResourceNotSet();
        }
        return null;
    }

    private EmbeddedCacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)ctx.lookup(jndiNamespace);
            return embeddedCacheManager;
        }
        catch (NamingException ne) {
            throw log.unableToRetrieveCmFromJndi(jndiNamespace);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.unableToReleaseContext(ne);
                }
            }
        }
    }
}

