/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EvictAllCommand;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

public class CacheCommandInitializer
implements ModuleCommandInitializer {
    private final ConcurrentHashMap<String, PutFromLoadValidator> putFromLoadValidators = new ConcurrentHashMap();
    @Inject
    private CacheNotifier notifier;
    @Inject
    private ClusteringDependentLogic clusteringDependentLogic;

    public void addPutFromLoadValidator(String cacheName, PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidators.put(cacheName, putFromLoadValidator);
    }

    public PutFromLoadValidator findPutFromLoadValidator(String cacheName) {
        return this.putFromLoadValidators.get(cacheName);
    }

    public PutFromLoadValidator removePutFromLoadValidator(String cacheName) {
        return this.putFromLoadValidators.remove(cacheName);
    }

    public EvictAllCommand buildEvictAllCommand(ByteString regionName) {
        return new EvictAllCommand(regionName);
    }

    public BeginInvalidationCommand buildBeginInvalidationCommand(long flagsBitSet, Object[] keys, Object lockOwner) {
        return new BeginInvalidationCommand(this.notifier, flagsBitSet, CommandInvocationId.generateId((Address)this.clusteringDependentLogic.getAddress()), keys, lockOwner);
    }

    public EndInvalidationCommand buildEndInvalidationCommand(ByteString cacheName, Object[] keys, Object lockOwner) {
        return new EndInvalidationCommand(cacheName, keys, lockOwner);
    }

    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        switch (c.getCommandId()) {
            case 121: {
                EndInvalidationCommand endInvalidationCommand = (EndInvalidationCommand)c;
                endInvalidationCommand.setPutFromLoadValidator(this.putFromLoadValidators.get(endInvalidationCommand.getCacheName().toString()));
                break;
            }
            case 122: {
                BeginInvalidationCommand beginInvalidationCommand = (BeginInvalidationCommand)c;
                beginInvalidationCommand.init(this.notifier);
            }
        }
    }
}

