/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.hibernate.cache.v51.functional.cluster;

import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.infinispan.hibernate.cache.v51.InfinispanRegionFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.hibernate.cache.commons.functional.cluster.ClusterAware;
import org.infinispan.test.hibernate.cache.commons.util.CacheTestUtil;

public class ClusterAwareRegionFactory
implements RegionFactory {
    private InfinispanRegionFactory delegate;
    private String cacheManagerName;
    private boolean locallyAdded;

    public ClusterAwareRegionFactory(Properties props) {
        Class regionFactoryClass = (Class)props.get("hibernate.cache.region.factory_delegate");
        this.delegate = (InfinispanRegionFactory)CacheTestUtil.createRegionFactory((Class)regionFactoryClass, (Properties)props);
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        this.cacheManagerName = properties.getProperty("hibernate.test.cluster.node.id");
        EmbeddedCacheManager existing = ClusterAware.getCacheManager((String)this.cacheManagerName);
        boolean bl = this.locallyAdded = existing == null;
        if (this.locallyAdded) {
            this.delegate.start(settings, properties);
            ClusterAware.addCacheManager((String)this.cacheManagerName, (EmbeddedCacheManager)this.delegate.getCacheManager());
        } else {
            this.delegate.setCacheManager(existing);
        }
    }

    public void stop() {
        if (this.locallyAdded) {
            ClusterAware.removeCacheManager((String)this.cacheManagerName);
        }
        this.delegate.stop();
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildCollectionRegion(regionName, properties, metadata);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildEntityRegion(regionName, properties, metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildNaturalIdRegion(regionName, properties, metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return this.delegate.buildQueryResultsRegion(regionName, properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return this.delegate.buildTimestampsRegion(regionName, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.delegate.isMinimalPutsEnabledByDefault();
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }
}

