/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v60.impl;

import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.hibernate.cache.v60.impl.RemovalInvocation;
import org.infinispan.hibernate.cache.v60.impl.Sync;
import org.infinispan.hibernate.cache.v60.impl.UpsertInvocation;

public class NonStrictAccessDelegate
extends org.infinispan.hibernate.cache.commons.access.NonStrictAccessDelegate {
    public NonStrictAccessDelegate(InfinispanDataRegion region, Comparator versionComparator) {
        super(region, versionComparator);
    }

    public void remove(Object session, Object key) throws CacheException {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        sync.registerAfterCommit(new RemovalInvocation((FunctionalMap.ReadWriteMap<Object, Object>)this.writeMap, this.region, key));
    }

    public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        sync.registerAfterCommit(new UpsertInvocation((FunctionalMap.ReadWriteMap<Object, Object>)this.writeMap, key, new VersionedEntry(value, version, sync.getCurrentTransactionStartTimestamp())));
        return false;
    }

    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        sync.registerAfterCommit(new UpsertInvocation((FunctionalMap.ReadWriteMap<Object, Object>)this.writeMap, key, new VersionedEntry(value, currentVersion, sync.getCurrentTransactionStartTimestamp())));
        return false;
    }

    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        return true;
    }

    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return true;
    }
}

