/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.access;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.hibernate.cache.impl.BaseTransactionalDataRegion;
import org.infinispan.hibernate.cache.util.FutureUpdate;
import org.infinispan.hibernate.cache.util.Tombstone;
import org.infinispan.hibernate.cache.util.TombstoneUpdate;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class TombstoneCallInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(TombstoneCallInterceptor.class);
    private static final UUID ZERO = new UUID(0L, 0L);
    private final BaseTransactionalDataRegion region;
    private final Metadata expiringMetadata;
    private Metadata defaultMetadata;
    private AdvancedCache cache;

    public TombstoneCallInterceptor(BaseTransactionalDataRegion region) {
        this.region = region;
        this.expiringMetadata = new EmbeddedMetadata.Builder().lifespan(region.getTombstoneExpiration(), TimeUnit.MILLISECONDS).build();
    }

    @Inject
    public void injectDependencies(AdvancedCache cache) {
        this.cache = cache;
    }

    @Start
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.cacheConfiguration.expiration().lifespan()).maxIdle(this.cacheConfiguration.expiration().maxIdle()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        log.tracef("In cache %s(%d) applying update %s to %s", new Object[]{this.cache.getName(), this.region.getLastRegionInvalidation(), command.getValue(), e.getValue()});
        try {
            Object value = command.getValue();
            if (value instanceof TombstoneUpdate) {
                Object object = this.handleTombstoneUpdate(ctx, e, (TombstoneUpdate)value, command);
                return object;
            }
            if (value instanceof Tombstone) {
                Object object = this.handleTombstone(e, (Tombstone)value, command);
                return object;
            }
            if (value instanceof FutureUpdate) {
                Object object = this.handleFutureUpdate(ctx, e, (FutureUpdate)value, command);
                return object;
            }
            Object object = super.visitPutKeyValueCommand(ctx, command);
            return object;
        }
        finally {
            log.tracef("Result is %s", e.getValue());
        }
    }

    private Object handleFutureUpdate(InvocationContext ctx, MVCCEntry e, FutureUpdate futureUpdate, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        if (!(storedValue instanceof Tombstone)) {
            return this.setFailed(ctx, command);
        }
        Tombstone tombstone = (Tombstone)storedValue;
        this.setValue(e, tombstone.applyUpdate(futureUpdate.getUuid(), futureUpdate.getTimestamp(), futureUpdate.getValue()), command);
        return null;
    }

    private Object handleTombstone(MVCCEntry e, Tombstone tombstone, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        if (storedValue instanceof Tombstone) {
            this.setValue(e, ((Tombstone)storedValue).merge(tombstone), command);
        } else {
            this.setValue(e, tombstone, command);
        }
        return null;
    }

    protected Object handleTombstoneUpdate(InvocationContext ctx, MVCCEntry e, TombstoneUpdate tombstoneUpdate, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        Object value = tombstoneUpdate.getValue();
        if (value == null) {
            if (storedValue == null || storedValue instanceof Tombstone) {
                return this.setFailed(ctx, command);
            }
            this.setValue(e, new Tombstone(ZERO, tombstoneUpdate.getTimestamp()), command);
        } else if (storedValue instanceof Tombstone) {
            Tombstone tombstone = (Tombstone)storedValue;
            if (tombstone.getLastTimestamp() < tombstoneUpdate.getTimestamp()) {
                this.setValue(e, value, command);
            }
        } else if (storedValue == null && this.region.getLastRegionInvalidation() < tombstoneUpdate.getTimestamp()) {
            this.setValue(e, value, command);
        }
        return null;
    }

    private Object setValue(MVCCEntry e, Object value, PutKeyValueCommand command) {
        if (e.isRemoved()) {
            e.setRemoved(false);
            e.setCreated(true);
            e.setValid(true);
        } else {
            e.setChanged(true);
        }
        if (value instanceof Tombstone) {
            command.setMetadata(this.expiringMetadata);
            e.setMetadata(this.expiringMetadata);
        } else {
            command.setMetadata(this.defaultMetadata);
            e.setMetadata(this.defaultMetadata);
        }
        return e.setValue(value);
    }

    private Object setFailed(InvocationContext ctx, PutKeyValueCommand command) {
        command.setValueMatcher(ValueMatcher.MATCH_NEVER);
        return this.invokeNextAndExceptionally(ctx, (VisitableCommand)command, (rCtx, rCommand, throwable) -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        Set flags = command.getFlags();
        int size = 0;
        AdvancedCache decoratedCache = this.cache.getAdvancedCache();
        if (flags != null) {
            decoratedCache = decoratedCache.withFlags(flags.toArray(new Flag[flags.size()]));
        }
        try (CloseableIterator it = Closeables.iterator((Stream)decoratedCache.cacheEntrySet().stream().filter(CacheFilters.predicate((KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES)));){
            while (it.hasNext()) {
                CacheEntry entry = (CacheEntry)it.next();
                if (size++ != Integer.MAX_VALUE) continue;
                Integer n = Integer.MAX_VALUE;
                return n;
            }
        }
        return size;
    }
}

