/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.timestamp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.timestamp.TimestampsRegionImpl;
import org.infinispan.hibernate.cache.util.Caches;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class ClusteredTimestampsRegionImpl
extends TimestampsRegionImpl {
    private final Map localCache = new ConcurrentHashMap();

    public ClusteredTimestampsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        cache.addListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.asyncWriteCache(cache, Flag.SKIP_LOCKING);
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        Object value = this.localCache.get(key);
        if (value == null && this.checkValid() && (value = this.cache.get(key)) != null) {
            this.localCache.put(key, value);
        }
        return value;
    }

    @Override
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public void invalidateRegion() {
        super.invalidateRegion();
        this.localCache.clear();
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.cache.removeListener((Object)this);
        super.destroy();
    }

    private void populateLocalCache() {
        try (CloseableIterator iterator = this.cache.keySet().iterator();){
            while (iterator.hasNext()) {
                this.get(null, iterator.next());
            }
        }
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (!event.isPre()) {
            this.localCache.put(event.getKey(), event.getValue());
        }
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.remove(event.getKey());
    }
}

