/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.access;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.hibernate.cache.access.BaseInvalidationInterceptor;
import org.infinispan.hibernate.cache.util.InfinispanMessageLogger;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class TxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TxInvalidationInterceptor.class);
    private static final Log ispnLog = LogFactory.getLog(TxInvalidationInterceptor.class);
    private final InvocationFinallyFunction broadcastClearIfNotLocal = this::broadcastClearIfNotLocal;
    private final InvocationFinallyFunction broadcastInvalidateForPrepare = this::broadcastInvalidateForPrepare;

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
        }
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextAndHandle(ctx, (VisitableCommand)command, this.broadcastClearIfNotLocal);
    }

    private Object broadcastClearIfNotLocal(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        FlagAffectedCommand flagCmd = (FlagAffectedCommand)rCommand;
        if (!this.isLocalModeForced(flagCmd) && rCtx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)rCommand, this.isSynchronous(flagCmd) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return rv;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getMap().keySet().toArray());
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.invokeNextAndHandle((InvocationContext)ctx, (VisitableCommand)command, this.broadcastInvalidateForPrepare);
    }

    private Object broadcastInvalidateForPrepare(InvocationContext rCtx, VisitableCommand rCommand, Object rv, Throwable t) throws Throwable {
        log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are empty", new Object[0]);
        TxInvocationContext txCtx = (TxInvocationContext)rCtx;
        if (this.shouldInvokeRemoteTxCommand(txCtx)) {
            if (txCtx.getTransaction() == null) {
                throw new IllegalStateException("We must have an associated transaction");
            }
            PrepareCommand prepareCmd = (PrepareCommand)rCommand;
            List<WriteCommand> mods = Arrays.asList(prepareCmd.getModifications());
            this.broadcastInvalidateForPrepare(mods, (InvocationContext)txCtx);
        } else {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        }
        return rv;
    }

    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            List<Address> members = this.getMembers();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(members);
            this.rpcManager.invokeRemotely(members, (ReplicableCommand)command, sync ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retVal;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        return this.invokeNextAndHandle(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> {
            WriteCommand writeCmd = (WriteCommand)rCommand;
            if (writeCmd.isSuccessful() && !rCtx.isInTxScope() && keys != null && keys.length != 0 && !this.isLocalModeForced((FlagAffectedCommand)writeCmd)) {
                this.invalidateAcrossCluster(this.isSynchronous((FlagAffectedCommand)writeCmd), keys, rCtx);
            }
            return rv;
        });
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope()) {
            if (modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, filterVisitor.result.toArray(), ctx);
                }
                catch (Throwable t) {
                    log.unableToRollbackInvalidationsDuringPrepare(t);
                    if (t instanceof RuntimeException) {
                        throw t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected Log getLog() {
        return ispnLog;
    }

    private void invalidateAcrossCluster(boolean synchronous, Object[] keys, InvocationContext ctx) throws Throwable {
        this.incrementInvalidations();
        InvalidateCommand invalidateCommand = this.commandsFactory.buildInvalidateCommand(0L, keys);
        if (log.isDebugEnabled()) {
            log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
        }
        InvalidateCommand command = invalidateCommand;
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), true);
        }
        this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, synchronous ? this.syncRpcOptions : this.asyncRpcOptions);
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains(Flag.CACHE_MODE_LOCAL);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains(Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

