/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.hibernate.cache.access.InvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.impl.BaseRegion;

public class NonTxInvalidationCacheAccessDelegate
extends InvalidationCacheAccessDelegate {
    public NonTxInvalidationCacheAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    @Override
    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            this.cache.clear();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }
}

