/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.main.timestamp;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.main.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.main.impl.BaseGeneralDataRegion;

public class TimestampsRegionImpl
extends BaseGeneralDataRegion
implements TimestampsRegion {
    private final AdvancedCache removeCache;
    private final AdvancedCache timestampsPutCache;

    public TimestampsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        this.removeCache = Caches.ignoreReturnValuesCache((AdvancedCache)cache);
        this.timestampsPutCache = this.getTimestampsPutCache(cache);
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        if (this.checkValid()) {
            return this.cache.get(key);
        }
        return null;
    }

    @Override
    public void put(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        try {
            this.timestampsPutCache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.ignoreReturnValuesCache((AdvancedCache)cache, (Flag)Flag.SKIP_LOCKING);
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.removeCache.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
        }
        finally {
            this.resume(tx);
        }
    }
}

