/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.main.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.main.access.AbstractAccess;
import org.infinispan.hibernate.cache.main.entity.EntityRegionImpl;

class ReadOnlyAccess
extends AbstractAccess
implements EntityRegionAccessStrategy {
    private final EntityRegionImpl region;

    public ReadOnlyAccess(EntityRegionImpl region, AccessDelegate delegate) {
        super(delegate);
        this.region = region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.insert((Object)session, key, value, version);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.afterInsert((Object)session, key, value, version);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get((Object)session, key, txTimestamp);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem((Object)session, key);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove((Object)session, key);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getEntityId(cacheKey);
    }

    public EntityRegion getRegion() {
        return this.region;
    }
}

