/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import org.infinispan.hotrod.impl.counter.operation.BaseCounterOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class RemoveListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;

    public RemoveListenerOperation(OperationContext operationContext, String counterName, byte[] listenerId, SocketAddress server) {
        super(operationContext, (short)92, (short)93, counterName, false);
        this.listenerId = listenerId;
        this.server = server;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, ByteBufUtil.estimateArraySize(this.listenerId));
        ByteBufUtil.writeArray(buf, this.listenerId);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        if (status == 0) {
            decoder.removeListener(this.listenerId);
        }
        this.complete(status == 0);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.server == null) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.server, this);
        }
    }
}

