/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.transport.netty.IOURingNativeTransport;

public final class NativeTransport {
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final String USE_IOURING_PROPERTY = "infinispan.server.channel.iouring";
    private static final boolean EPOLL_DISABLED = System.getProperty("infinispan.server.channel.epoll", "true").equalsIgnoreCase("false");
    private static final boolean IOURING_DISABLED = System.getProperty("infinispan.server.channel.iouring", "true").equalsIgnoreCase("false");
    static final boolean USE_NATIVE_EPOLL = NativeTransport.useNativeEpoll();
    static final boolean USE_NATIVE_IOURING = NativeTransport.useNativeIOUring();

    private static boolean useNativeEpoll() {
        block4: {
            try {
                Class.forName("io.netty.channel.epoll.Epoll", true, NativeTransport.class.getClassLoader());
                if (Epoll.isAvailable()) {
                    return !EPOLL_DISABLED && IS_LINUX;
                }
                if (IS_LINUX) {
                    Log.HOTROD.epollNotAvailable(Epoll.unavailabilityCause().toString());
                }
            }
            catch (ClassNotFoundException e) {
                if (!IS_LINUX) break block4;
                Log.HOTROD.epollNotAvailable(e.getMessage());
            }
        }
        return false;
    }

    private static boolean useNativeIOUring() {
        block4: {
            try {
                Class.forName("io.netty.incubator.channel.uring.IOUring", true, NativeTransport.class.getClassLoader());
                if (IOUring.isAvailable()) {
                    return !IOURING_DISABLED && IS_LINUX;
                }
                if (IS_LINUX) {
                    Log.HOTROD.ioUringNotAvailable(IOUring.unavailabilityCause().toString());
                }
            }
            catch (ClassNotFoundException e) {
                if (!IS_LINUX) break block4;
                Log.HOTROD.ioUringNotAvailable(e.getMessage());
            }
        }
        return false;
    }

    public static Class<? extends SocketChannel> socketChannelClass() {
        if (USE_NATIVE_EPOLL) {
            return EpollSocketChannel.class;
        }
        if (USE_NATIVE_IOURING) {
            return IOURingNativeTransport.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> datagramChannelClass() {
        if (USE_NATIVE_EPOLL) {
            return EpollDatagramChannel.class;
        }
        if (USE_NATIVE_IOURING) {
            return IOURingNativeTransport.datagramChannelClass();
        }
        return NioDatagramChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int maxExecutors, ExecutorService executorService) {
        if (USE_NATIVE_EPOLL) {
            return new EpollEventLoopGroup(maxExecutors, (Executor)executorService);
        }
        if (USE_NATIVE_IOURING) {
            return IOURingNativeTransport.createEventLoopGroup(maxExecutors, executorService);
        }
        return new NioEventLoopGroup(maxExecutors, (Executor)executorService);
    }
}

