/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;

public class SslConfiguration
extends ConfigurationElement<SslConfiguration> {
    static final AttributeDefinition<String[]> CIPHERS = AttributeDefinition.builder((String)"ciphers", null, String[].class).immutable().build();
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"use-ssl", (Object)false, Boolean.class).immutable().build();
    static final AttributeDefinition<String> KEY_ALIAS = AttributeDefinition.builder((String)"key-alias", null, String.class).immutable().build();
    static final AttributeDefinition<String> KEYSTORE_FILENAME = AttributeDefinition.builder((String)"keystore-filename", null, String.class).immutable().build();
    static final AttributeDefinition<char[]> KEYSTORE_PASSWORD = AttributeDefinition.builder((String)"keystore-password", null, char[].class).immutable().build();
    static final AttributeDefinition<String> KEYSTORE_TYPE = AttributeDefinition.builder((String)"keystore-type", (Object)KeyStore.getDefaultType(), String.class).immutable().build();
    static final AttributeDefinition<String> PROTOCOL = AttributeDefinition.builder((String)"protocol", null, String.class).immutable().build();
    static final AttributeDefinition<String> PROVIDER = AttributeDefinition.builder((String)"provider", null, String.class).immutable().build();
    static final AttributeDefinition<String> SNI_HOSTNAME = AttributeDefinition.builder((String)"sni-hostname", null, String.class).immutable().build();
    static final AttributeDefinition<SSLContext> SSL_CONTEXT = AttributeDefinition.builder((String)"ssl-context", null, SSLContext.class).immutable().build();
    static final AttributeDefinition<Boolean> HOSTNAME_VALIDATION = AttributeDefinition.builder((String)"ssl-hostname-validation", (Object)true).immutable().build();
    static final AttributeDefinition<String> TRUSTSTORE_FILENAME = AttributeDefinition.builder((String)"truststore-filename", null, String.class).immutable().build();
    static final AttributeDefinition<char[]> TRUSTSTORE_PASSWORD = AttributeDefinition.builder((String)"truststore-password", null, char[].class).immutable().build();
    static final AttributeDefinition<String> TRUSTSTORE_TYPE = AttributeDefinition.builder((String)"truststore-type", (Object)KeyStore.getDefaultType(), String.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SslConfiguration.class, new AttributeDefinition[]{ENABLED, KEY_ALIAS, KEYSTORE_FILENAME, KEYSTORE_PASSWORD, KEYSTORE_TYPE, PROTOCOL, PROVIDER, SNI_HOSTNAME, SSL_CONTEXT, HOSTNAME_VALIDATION, TRUSTSTORE_FILENAME, TRUSTSTORE_PASSWORD, TRUSTSTORE_TYPE});
    }

    SslConfiguration(AttributeSet attributes) {
        super("ssl", attributes, new ConfigurationElement[0]);
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String keyStoreFileName() {
        return (String)this.attributes.attribute(KEYSTORE_FILENAME).get();
    }

    public String keyStoreType() {
        return (String)this.attributes.attribute(KEYSTORE_TYPE).get();
    }

    public char[] keyStorePassword() {
        return (char[])this.attributes.attribute(KEYSTORE_PASSWORD).get();
    }

    public String keyAlias() {
        return (String)this.attributes.attribute(KEY_ALIAS).get();
    }

    public SSLContext sslContext() {
        return (SSLContext)this.attributes.attribute(SSL_CONTEXT).get();
    }

    public boolean hostnameValidation() {
        return (Boolean)this.attributes.attribute(HOSTNAME_VALIDATION).get();
    }

    public String trustStoreFileName() {
        return (String)this.attributes.attribute(TRUSTSTORE_FILENAME).get();
    }

    public String trustStoreType() {
        return (String)this.attributes.attribute(TRUSTSTORE_TYPE).get();
    }

    public char[] trustStorePassword() {
        return (char[])this.attributes.attribute(TRUSTSTORE_PASSWORD).get();
    }

    public String sniHostName() {
        return (String)this.attributes.attribute(SNI_HOSTNAME).get();
    }

    public String protocol() {
        return (String)this.attributes.attribute(PROTOCOL).get();
    }

    public String[] ciphers() {
        return (String[])this.attributes.attribute(CIPHERS).get();
    }

    public String provider() {
        return (String)this.attributes.attribute(PROVIDER).get();
    }
}

