/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class RemoveClientListenerOperation
extends HotRodOperation<Void>
implements ChannelOperation {
    private final Object listener;
    private byte[] listenerId;

    protected RemoveClientListenerOperation(OperationContext operationContext, CacheOptions options, Object listener) {
        super(operationContext, (short)39, (short)40, options);
        this.listener = listener;
    }

    protected void fetchChannelAndInvoke() {
        this.listenerId = this.operationContext.getListenerNotifier().findListenerId(this.listener);
        if (this.listenerId != null) {
            SocketAddress address = this.operationContext.getListenerNotifier().findAddress(this.listenerId);
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(address, this);
        } else {
            this.complete(null);
        }
    }

    @Override
    public void invoke(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.listenerId);
        this.releaseChannel(channel);
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status) || HotRodConstants.isNotExecuted(status)) {
            this.operationContext.getListenerNotifier().removeClientListener(this.listenerId);
        }
        this.complete(null);
    }

    @Override
    public CompletableFuture<Void> execute() {
        try {
            this.fetchChannelAndInvoke();
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return this;
    }
}

