/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling.core;

import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.jboss.marshalling.commons.AbstractJBossMarshaller;
import org.infinispan.jboss.marshalling.commons.DefaultContextClassResolver;
import org.infinispan.jboss.marshalling.commons.SerializeWithExtFactory;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.ObjectTable;

public class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    GlobalConfiguration globalCfg;
    ObjectTable objectTable;

    JBossMarshaller() {
        this(null, null);
    }

    JBossMarshaller(ObjectTable objectTable, GlobalConfiguration globalCfg) {
        this.objectTable = objectTable;
        this.globalCfg = globalCfg;
    }

    @Override
    public void start() {
        super.start();
        this.baseCfg.setClassExternalizerFactory((ClassExternalizerFactory)new SerializeWithExtFactory());
        this.baseCfg.setObjectTable(this.objectTable);
        Object classResolver = (ClassResolver)this.globalCfg.serialization().classResolver();
        if (classResolver == null) {
            ClassLoader cl = this.globalCfg.classLoader();
            classResolver = new DefaultContextClassResolver(cl);
        }
        this.baseCfg.setClassResolver(classResolver);
    }

    @Override
    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
    }

    @Override
    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || o.getClass().getAnnotation(SerializeWith.class) != null || o.getClass().getAnnotation(Externalize.class) != null;
    }
}

