/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling.dataconversion;

import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JBossMarshallingTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JBossMarshallingTranscoder.class, Log.class);
    private final Marshaller marshaller;

    public JBossMarshallingTranscoder(Marshaller marshaller) {
        super(MediaType.APPLICATION_JBOSS_MARSHALLING, new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_UNKNOWN});
        if (!marshaller.mediaType().match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            throw new IllegalArgumentException("Provided Marshaller " + String.valueOf(marshaller) + " cannot handle: " + String.valueOf(MediaType.APPLICATION_JBOSS_MARSHALLING));
        }
        this.marshaller = marshaller;
    }

    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                content = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
            }
            if (contentType.match(MediaType.APPLICATION_UNKNOWN) || contentType.match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
                return content;
            }
            return this.marshall(content);
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            try {
                Object unmarshalled = this.unmarshall(content);
                if (unmarshalled instanceof byte[]) {
                    return unmarshalled;
                }
                return this.marshaller.objectToByteBuffer(unmarshalled);
            }
            catch (IOException | InterruptedException e) {
                throw logger.cannotConvertContent(JBossMarshallingTranscoder.class.getSimpleName(), content, contentType, destinationType);
            }
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            String unmarshalled = this.unmarshall(content).toString();
            return unmarshalled.getBytes(destinationType.getCharset());
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            return this.unmarshall(content);
        }
        if (destinationType.equals((Object)MediaType.APPLICATION_UNKNOWN)) {
            return content;
        }
        throw logger.cannotConvertContent(JBossMarshallingTranscoder.class.getSimpleName(), content, contentType, destinationType);
    }

    private byte[] marshall(Object o) {
        try {
            return this.marshaller.objectToByteBuffer(o);
        }
        catch (IOException | InterruptedException e) {
            throw logger.errorTranscoding(JBossMarshallingTranscoder.class.getSimpleName(), (Throwable)e);
        }
    }

    private Object unmarshall(Object o) {
        try {
            return o instanceof byte[] ? this.marshaller.objectFromByteBuffer((byte[])o) : o;
        }
        catch (IOException | ClassNotFoundException e) {
            throw logger.errorTranscoding(JBossMarshallingTranscoder.class.getSimpleName(), (Throwable)e);
        }
    }
}

