/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.SecurityActions;

final class RIMBeanServerRegistrationUtility {
    private RIMBeanServerRegistrationUtility() {
    }

    static void registerCacheObject(AbstractJCache<?, ?> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        if (mBeanServer != null) {
            Object mBean;
            switch (objectNameType) {
                case CONFIGURATION: {
                    mBean = cache.getCacheMXBean();
                    break;
                }
                case STATISTICS: {
                    mBean = cache.getCacheStatisticsMXBean();
                    break;
                }
                default: {
                    throw new CacheException("Unrecognized ObjectNameType : " + (Object)((Object)objectNameType));
                }
            }
            ObjectName objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
            try {
                if (!mBeanServer.isRegistered(objectName)) {
                    SecurityActions.registerMBean(mBean, objectName, mBeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Error registering cache MXBeans for CacheManager " + objectName + ". Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static void unregisterCacheObject(AbstractJCache<?, ?> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        if (mBeanServer != null) {
            ObjectName objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
            try {
                if (mBeanServer.isRegistered(objectName)) {
                    SecurityActions.unregisterMBean(objectName, mBeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering MBean " + objectName + ". Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ObjectName calculateObjectName(AbstractJCache<?, ?> cache, ObjectNameType objectNameType) {
        String cacheManagerName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getCacheManager().getURI().toString());
        String cacheName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getName());
        try {
            return new ObjectName("javax.cache:type=Cache" + objectNameType.objectName + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll("[,:=\n]", ".");
    }

    static enum ObjectNameType {
        STATISTICS("Statistics"),
        CONFIGURATION("Configuration");

        private final String objectName;

        private ObjectNameType(String objectName) {
            this.objectName = objectName;
        }
    }
}

