/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import javax.cache.Cache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.commons.util.KeyValueWithPrevious;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.AbstractJCacheNotifier;

@ClientListener(converterFactoryName="key-value-with-previous-converter-factory")
public class JCacheListenerAdapter<K, V>
extends AbstractJCacheListenerAdapter<K, V> {
    public JCacheListenerAdapter(AbstractJCache<K, V> jcache, AbstractJCacheNotifier<K, V> notifier) {
        super(jcache, notifier);
    }

    @ClientCacheEntryCreated
    @ClientCacheEntryModified
    @ClientCacheEntryRemoved
    @ClientCacheEntryExpired
    public void handleCacheEntryEvent(ClientCacheEntryCustomEvent<KeyValueWithPrevious<K, V>> e) {
        KeyValueWithPrevious event = (KeyValueWithPrevious)e.getEventData();
        switch (e.getType()) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                this.notifier.notifyEntryCreated((Cache)this.jcache, event.getKey(), event.getValue());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                this.notifier.notifyEntryRemoved((Cache)this.jcache, event.getKey(), event.getPrev(), event.getPrev());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                this.notifier.notifyEntryUpdated((Cache)this.jcache, event.getKey(), event.getValue(), event.getPrev());
                break;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                this.notifier.notifyEntryExpired((Cache)this.jcache, event.getKey(), event.getValue());
                break;
            }
            case CLIENT_CACHE_FAILOVER: {
                break;
            }
        }
    }
}

