/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.GlobalContextInitializer;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheManager;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jcache.remote.ConfigurationAdapter;
import org.infinispan.jcache.remote.JCache;
import org.infinispan.protostream.SerializationContext;

public class JCacheManager
extends AbstractJCacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    private RemoteCacheManager cm;
    private RemoteCacheManager cmForceReturnValue;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        super(uri, classLoader, provider, properties, false);
        ConfigurationBuilder builder = this.getConfigurationBuilder(properties);
        Configuration configuration = builder.build();
        this.cm = new RemoteCacheManager(configuration, true);
        this.initializeProtoContext(this.cm.getMarshaller());
        builder.forceReturnValues(true);
        this.cmForceReturnValue = new RemoteCacheManager(builder.build(), true);
    }

    private void initializeProtoContext(Marshaller marshaller) {
        if (marshaller instanceof ProtoStreamMarshaller) {
            SerializationContext ctx = ((ProtoStreamMarshaller)marshaller).getSerializationContext();
            GlobalContextInitializer.INSTANCE.registerSchema(ctx);
            GlobalContextInitializer.INSTANCE.registerMarshallers(ctx);
        }
    }

    private ConfigurationBuilder getConfigurationBuilder(Properties userProperties) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (userProperties != null && !userProperties.isEmpty()) {
            this.properties = userProperties;
            builder.withProperties(userProperties);
        } else {
            InputStream is = this.findPropertiesFile();
            if (is != null) {
                Properties fileProperties = new Properties();
                try {
                    fileProperties.load(is);
                    this.properties = fileProperties;
                    builder.withProperties(fileProperties);
                }
                catch (IOException e) {
                    throw new CacheException("Unable to load properties from `hotrod-client.properties`", (Throwable)e);
                }
            } else {
                builder.addServer().host("127.0.0.1").port(11222);
            }
        }
        return builder;
    }

    private InputStream findPropertiesFile() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return FileLookupFactory.newInstance().lookupFile("hotrod-client.properties", cl);
    }

    public ClassLoader getClassLoader() {
        return this.cm.getConfiguration().classLoader();
    }

    protected <K, V, C extends javax.cache.configuration.Configuration<K, V>> AbstractJCache<K, V> create(String cacheName, C configuration) {
        ConfigurationAdapter adapter = ConfigurationAdapter.create(configuration);
        this.cm.administration().getOrCreateCache(cacheName, (String)null);
        return this.createJCache(cacheName, adapter);
    }

    private <K, V> AbstractJCache<K, V> createJCache(String cacheName, ConfigurationAdapter<K, V> adapter) {
        RemoteCache<K, V> ispnCache = this.getRemoteCache(this.cm, cacheName);
        RemoteCache<K, V> ispnCacheForceReturnValue = this.getRemoteCache(this.cmForceReturnValue, cacheName);
        return new JCache<K, V>(ispnCache, ispnCacheForceReturnValue, (CacheManager)this, adapter);
    }

    private <K, V> RemoteCache<K, V> getRemoteCache(RemoteCacheManager cm, String cacheName) {
        RemoteCache ispnCache = cm.getCache(cacheName);
        if (ispnCache == null) {
            throw log.cacheNotFound(cacheName);
        }
        return ispnCache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache<K, V> cache = super.getCache(cacheName);
        return Objects.isNull(cache) ? this.createRegisterJCache(cacheName) : cache;
    }

    public <K, V> Cache<K, V> createRegisterJCache(String cacheName) {
        RemoteCache ispnCache = this.cm.getCache(cacheName);
        RemoteCache ispnCacheForceReturnValue = this.cmForceReturnValue.getCache(cacheName);
        if (ispnCache != null && this.cmForceReturnValue != null) {
            ConfigurationAdapter adapter = ConfigurationAdapter.create();
            JCache jcache = new JCache(ispnCache, ispnCacheForceReturnValue, (CacheManager)this, adapter);
            this.registerPredefinedCache(cacheName, jcache);
            return jcache;
        }
        return null;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        Cache<K, V> cache = super.getCache(cacheName, keyType, valueType);
        return Objects.isNull(cache) ? this.createRegisterJCache(cacheName) : cache;
    }

    protected <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I ispnCache) {
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)((Object)this), clazz);
    }

    protected Iterable<String> delegateCacheNames() {
        return this.getManagedCacheNames();
    }

    protected void delegateStop() {
        this.cm.stop();
        this.cmForceReturnValue.stop();
    }

    protected boolean delegateIsClosed() {
        return false;
    }

    protected <K, V> void delegateRemoveCache(AbstractJCache<K, V> jcache) {
        this.cm.administration().removeCache(jcache.getName());
    }

    protected void delegateLogIsClosed() {
        throw log.cacheClosed();
    }
}

