/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.remote.RemoteCacheWrapper;

public abstract class RemoteCacheWithCacheStore<K, V>
extends RemoteCacheWrapper<K, V> {
    private final CacheLoader<K, V> jcacheLoader;
    private final CacheWriter<? super K, ? super V> jcacheWriter;
    private final MutableConfiguration<K, V> configuration;

    public RemoteCacheWithCacheStore(RemoteCache<K, V> delegate, CacheLoader<K, V> jcacheLoader, CacheWriter<? super K, ? super V> jcacheWriter, MutableConfiguration<K, V> configuration) {
        super(delegate);
        this.jcacheLoader = jcacheLoader;
        this.jcacheWriter = jcacheWriter;
        this.configuration = configuration;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value == null) {
            try {
                value = this.loadFromCacheLoader(key);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return value;
    }

    private V loadFromCacheLoader(K key) {
        if (this.jcacheLoader == null || !this.configuration.isReadThrough()) {
            return null;
        }
        Object value = null;
        try {
            value = this.jcacheLoader.load(key);
        }
        catch (Exception ex) {
            throw Exceptions.launderCacheLoaderException((Exception)ex);
        }
        if (value != null) {
            this.onLoad(key, value);
        }
        return (V)value;
    }

    protected abstract void onLoad(K var1, V var2);
}

