/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class ServerManager {
    private String host;
    private int port;

    public ServerManager(String host) {
        this(host, 9990);
    }

    public ServerManager(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Set<String> getCacheNames() throws NotAvailableException, ManagementClientException {
        ServerManager.checkServerManagementAvailable();
        final HashSet<String> result = new HashSet<String>();
        ServerManager.withManagementClient(this.host, this.port, new ManagementRunnable(){

            @Override
            public void run(ModelControllerClient client) throws Exception {
                PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"infinispan").append("cache-container", ServerManager.this.getHotRodCacheContainer(client));
                ModelNode op = new ModelNode();
                op.get("operation").set("read-children-names");
                op.get("address").set(pathAddress.toModelNode());
                op.get("child-type").set("local-cache");
                ModelNode resp = client.execute(op);
                if (!"success".equals(resp.get("outcome").asString())) {
                    throw new IllegalArgumentException(resp.asString());
                }
                if (!resp.has("result")) {
                    return;
                }
                List modelNodes = resp.get("result").asList();
                for (ModelNode modelNode : modelNodes) {
                    result.add(modelNode.asString());
                }
            }
        });
        return result;
    }

    private void checkExistence(final String cacheType, final String cacheName, final AtomicBoolean result) throws ManagementClientException {
        if (!result.get()) {
            ServerManager.withManagementClient(this.host, this.port, new ManagementRunnable(){

                @Override
                public void run(ModelControllerClient client) throws Exception {
                    PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"infinispan").append("cache-container", ServerManager.this.getHotRodCacheContainer(client)).append(cacheType, cacheName);
                    ModelNode op = new ModelNode();
                    op.get("operation").set("read-attribute");
                    op.get("address").set(pathAddress.toModelNode());
                    op.get("name").set("start");
                    ModelNode resp = client.execute(op);
                    if ("success".equals(resp.get("outcome").asString())) {
                        result.set(true);
                    }
                }
            });
        }
    }

    public boolean containsCache(String cacheName) throws NotAvailableException, ManagementClientException {
        ServerManager.checkServerManagementAvailable();
        AtomicBoolean result = new AtomicBoolean(false);
        this.checkExistence("local-cache", cacheName, result);
        this.checkExistence("distributed-cache", cacheName, result);
        this.checkExistence("replicated-cache", cacheName, result);
        this.checkExistence("invalidation-cache", cacheName, result);
        return result.get();
    }

    public void addCache(final String cacheName) throws NotAvailableException, ManagementClientException {
        ServerManager.checkServerManagementAvailable();
        ServerManager.withManagementClient(this.host, this.port, new ManagementRunnable(){

            @Override
            public void run(ModelControllerClient client) throws Exception {
                PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"infinispan").append("cache-container", ServerManager.this.getHotRodCacheContainer(client)).append("local-cache", cacheName);
                ModelNode op = new ModelNode();
                op.get("operation").set("add");
                op.get("address").set(pathAddress.toModelNode());
                op.get("start").set("EAGER");
                ModelNode resp = client.execute(op);
                if (!"success".equals(resp.get("outcome").asString())) {
                    throw new IllegalArgumentException(resp.asString());
                }
            }
        });
    }

    public void removeCache(final String cacheName) throws NotAvailableException, ManagementClientException {
        ServerManager.checkServerManagementAvailable();
        ServerManager.withManagementClient(this.host, this.port, new ManagementRunnable(){

            @Override
            public void run(ModelControllerClient client) throws Exception {
                PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"infinispan").append("cache-container", ServerManager.this.getHotRodCacheContainer(client)).append("local-cache", cacheName);
                ModelNode op = new ModelNode();
                op.get("operation").set("remove");
                op.get("address").set(pathAddress.toModelNode());
                ModelNode resp = client.execute(op);
                if (!"success".equals(resp.get("outcome").asString())) {
                    // empty if block
                }
            }
        });
    }

    private String getHotRodCacheContainer(ModelControllerClient client) throws IOException {
        PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"endpoint").append("hotrod-connector", "hotrod-connector");
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(pathAddress.toModelNode());
        op.get("name").set("cache-container");
        ModelNode resp = client.execute(op);
        if (!"success".equals(resp.get("outcome").asString())) {
            throw new IllegalArgumentException(resp.asString());
        }
        return resp.get("result").asString();
    }

    private static void withManagementClient(String host, int port, ManagementRunnable runnable) throws ManagementClientException {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new ManagementClientException(String.format("Failed to resolve host '%s'.", host), ex);
        }
        ModelControllerClient client = ModelControllerClient.Factory.create((String)"http-remoting", (InetAddress)addr, (int)port);
        try {
            runnable.run(client);
        }
        catch (Exception ex) {
            throw new ManagementClientException("", ex);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {}
        }
    }

    private static void checkServerManagementAvailable() throws NotAvailableException {
        try {
            boolean skipServerMgmtLookup = Boolean.parseBoolean(System.getProperty("infinispan.jcache.mgmt.lookup.skip", "false"));
            if (skipServerMgmtLookup) {
                throw new NotAvailableException();
            }
            Class.forName("org.jboss.as.controller.client.ModelControllerClient");
        }
        catch (ClassNotFoundException e) {
            throw new NotAvailableException();
        }
    }

    public static class ManagementClientException
    extends Exception {
        private static final long serialVersionUID = -5857650491476258495L;

        public ManagementClientException() {
        }

        public ManagementClientException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NotAvailableException
    extends Exception {
        private static final long serialVersionUID = 2036495722939416728L;

        public NotAvailableException() {
        }

        public NotAvailableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static interface ManagementRunnable {
        public void run(ModelControllerClient var1) throws Exception;
    }
}

