/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;

public class JCacheLoaderAdapter<K, V>
implements CacheLoader {
    private javax.cache.integration.CacheLoader<K, V> delegate;
    private InitializationContext ctx;
    private ExpiryPolicy expiryPolicy;

    public void setCacheLoader(javax.cache.integration.CacheLoader<K, V> delegate) {
        this.delegate = delegate;
    }

    public void setExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
    }

    public MarshallableEntry<K, V> loadEntry(Object key) throws PersistenceException {
        V value = this.loadValue(key);
        if (value != null) {
            Duration expiry = Expiration.getExpiry((ExpiryPolicy)this.expiryPolicy, (Expiration.Operation)Expiration.Operation.CREATION);
            if (expiry == null || expiry.isEternal()) {
                return this.ctx.getMarshallableEntryFactory().create(key, value);
            }
            long now = this.ctx.getTimeService().wallClockTime();
            long exp = now + expiry.getTimeUnit().toMillis(expiry.getDurationAmount());
            Metadata meta = new EmbeddedMetadata.Builder().lifespan(exp - now).build();
            return this.ctx.getMarshallableEntryFactory().create(key, value, meta, now, -1L);
        }
        return null;
    }

    private V loadValue(Object key) {
        try {
            return (V)this.delegate.load(key);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheLoaderException((Exception)e);
        }
    }

    public void start() throws PersistenceException {
    }

    public void stop() throws PersistenceException {
    }

    public boolean contains(Object key) {
        return this.loadEntry(key) != null;
    }
}

