/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import javax.cache.Cache;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.AbstractJCacheNotifier;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class JCacheListenerAdapter<K, V>
extends AbstractJCacheListenerAdapter<K, V> {
    public JCacheListenerAdapter(AbstractJCache<K, V> jcache, AbstractJCacheNotifier<K, V> notifier) {
        super(jcache, notifier);
    }

    @CacheEntryCreated
    public void handleCacheEntryCreatedEvent(CacheEntryCreatedEvent<K, V> e) {
        if (!e.isPre()) {
            this.notifier.notifyEntryCreated((Cache)this.jcache, e.getKey(), e.getValue());
        }
    }

    @CacheEntryModified
    public void handleCacheEntryModifiedEvent(CacheEntryModifiedEvent<K, V> e) {
        if (!e.isPre() && !e.isCreated()) {
            this.notifier.notifyEntryUpdated((Cache)this.jcache, e.getKey(), e.getValue(), e.getValue());
        }
    }

    @CacheEntryRemoved
    public void handleCacheEntryRemovedEvent(CacheEntryRemovedEvent<K, V> e) {
        if (!e.isPre()) {
            this.notifier.notifyEntryRemoved((Cache)this.jcache, e.getKey(), e.getOldValue(), e.getOldValue());
        }
    }

    @CacheEntryExpired
    public void handleCacheEntryExpiredEvent(CacheEntryExpiredEvent<K, V> e) {
        if (!e.isPre()) {
            this.notifier.notifyEntryExpired((Cache)this.jcache, e.getKey(), e.getValue());
        }
    }
}

