package org.infinispan.jcache.embedded.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URI;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import org.infinispan.lifecycle.ComponentStatus;
import java.util.Collection;
import java.lang.Throwable;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-09-08T06:57:35-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String parameterMustNotBeNull$str() {
        return "ISPN021010: '%s' parameter must not be null";
    }
    @Override
    public final NullPointerException parameterMustNotBeNull(final String parameterName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), parameterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void errorLoadingAll(final Collection<?> keysToLoad, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorLoadingAll$str(), keysToLoad);
    }
    protected String errorLoadingAll$str() {
        return "ISPN021017: Error loading %s keys from persistence store";
    }
    protected String cacheManagerClosed$str() {
        return "ISPN021020: Cache manager %s has status %s";
    }
    @Override
    public final IllegalStateException cacheManagerClosed(final URI managerURI, final ComponentStatus status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheManagerClosed$str(), managerURI, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheClosed$str() {
        return "ISPN021021: Cache %s on %s has status %s";
    }
    @Override
    public final IllegalStateException cacheClosed(final String cacheName, final URI managerURI, final ComponentStatus status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheClosed$str(), cacheName, managerURI, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
