/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.interceptor;

import javax.cache.Cache;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jcache.JCacheNotifier;

public class ExpirationTrackingInterceptor
extends CommandInterceptor {
    private final DataContainer container;
    private final Cache<Object, Object> cache;
    private final JCacheNotifier<Object, Object> notifier;

    public ExpirationTrackingInterceptor(DataContainer container, Cache<?, ?> cache, JCacheNotifier<?, ?> notifier) {
        this.container = container;
        this.cache = cache;
        this.notifier = notifier;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        InternalCacheEntry entry = this.container.peek(key);
        if (entry != null && entry.canExpire() && entry.isExpired()) {
            this.notifier.notifyEntryExpired(this.cache, key, entry.getValue());
        }
        return super.visitGetKeyValueCommand(ctx, command);
    }
}

