/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.Cache;
import org.infinispan.AdvancedCache;

public final class MutableJCacheEntry<K, V>
implements Cache.MutableEntry<K, V> {
    private final AdvancedCache<K, V> cache;
    private final K key;
    private final V oldValue;
    private V value;
    private boolean removed;

    public MutableJCacheEntry(AdvancedCache<K, V> cache, K key, V value) {
        this.cache = cache;
        this.key = key;
        this.oldValue = value;
    }

    public boolean exists() {
        if (this.value != null) {
            return true;
        }
        if (!this.removed) {
            return this.cache.containsKey(this.key);
        }
        return false;
    }

    public void remove() {
        this.removed = true;
        this.value = null;
    }

    public void setValue(V value) {
        this.value = value;
        this.removed = false;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (!this.removed) {
            this.cache.get(this.key);
            return this.oldValue;
        }
        return null;
    }

    V getNewValue() {
        return this.value;
    }

    boolean isRemoved() {
        return this.removed;
    }
}

