/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheLoader;
import javax.cache.CacheMXBean;
import javax.cache.CacheManager;
import javax.cache.CacheStatisticsMXBean;
import javax.cache.CacheWriter;
import javax.cache.Configuration;
import javax.cache.ExpiryPolicy;
import javax.cache.Factory;
import javax.cache.MutableConfiguration;
import javax.cache.Status;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryListenerRegistration;
import javax.cache.event.CompletionListener;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.JCacheListenerAdapter;
import org.infinispan.jcache.JCacheListenerRegistration;
import org.infinispan.jcache.JCacheLoaderAdapter;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.jcache.JCacheNotifier;
import org.infinispan.jcache.JCacheWriterAdapter;
import org.infinispan.jcache.JStatusConverter;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.RICacheStatistics;
import org.infinispan.jcache.RIDelegatingCacheMXBean;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.interceptor.ExpirationTrackingInterceptor;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.LogFactory;

public final class JCache<K, V>
implements Cache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCache.class, Log.class);
    private final JCacheManager cacheManager;
    private final Configuration<K, V> configuration;
    private final AdvancedCache<K, V> cache;
    private final AdvancedCache<K, V> ignoreReturnValuesCache;
    private final AdvancedCache<K, V> skipCacheLoadCache;
    private final AdvancedCache<K, V> skipCacheLoadAndStatsCache;
    private final AdvancedCache<K, V> skipStatsCache;
    private final AdvancedCache<K, V> skipListenerCache;
    private final CacheStatisticsMXBean stats;
    private final CacheMXBean mxBean;
    private final JCacheNotifier<K, V> notifier;
    private final ExpiryPolicy<? super K, ? super V> expiryPolicy;
    private final LockContainer processorLocks = new ReentrantPerEntryLockContainer(32);
    private final long lockTimeout;
    private CacheLoader<? super K, ? super V> cacheLoader;

    public JCache(AdvancedCache<K, V> cache, JCacheManager cacheManager, Configuration<K, V> c) {
        this.cache = cache;
        this.ignoreReturnValuesCache = cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.skipCacheLoadCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
        this.skipCacheLoadAndStatsCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_STATISTICS});
        this.skipStatsCache = cache.withFlags(new Flag[]{Flag.SKIP_STATISTICS});
        this.skipListenerCache = cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
        this.cacheManager = cacheManager;
        this.configuration = new MutableConfiguration(c).setManagementEnabled(c.isManagementEnabled());
        this.mxBean = new RIDelegatingCacheMXBean(this);
        this.stats = new RICacheStatistics(this.cache);
        this.expiryPolicy = (ExpiryPolicy)this.configuration.getExpiryPolicyFactory().create();
        this.lockTimeout = cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        this.notifier = new JCacheNotifier();
        for (CacheEntryListenerRegistration r : c.getCacheEntryListenerRegistrations()) {
            this.notifier.addListener(r);
        }
        this.setCacheLoader(cache, c);
        this.setCacheWriter(cache, c);
        this.addExpirationTrackingInterceptor(cache, this.notifier);
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private void setCacheLoader(AdvancedCache<K, V> cache, Configuration<K, V> c) {
        Factory cacheLoaderFactory = c.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            CacheLoaderManager loaderManager = (CacheLoaderManager)cache.getComponentRegistry().getComponent(CacheLoaderManager.class);
            JCacheLoaderAdapter ispnCacheLoader = (JCacheLoaderAdapter)loaderManager.getCacheLoader();
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
            ispnCacheLoader.setCacheLoader(this.cacheLoader);
        }
    }

    private void setCacheWriter(AdvancedCache<K, V> cache, Configuration<K, V> c) {
        Factory cacheWriterFactory = c.getCacheWriterFactory();
        if (cacheWriterFactory != null) {
            CacheLoaderManager loaderManager = (CacheLoaderManager)cache.getComponentRegistry().getComponent(CacheLoaderManager.class);
            JCacheWriterAdapter ispnCacheStore = (JCacheWriterAdapter)loaderManager.getCacheStore();
            ispnCacheStore.setCacheWriter((CacheWriter)cacheWriterFactory.create());
        }
    }

    private final void addExpirationTrackingInterceptor(AdvancedCache<K, V> cache, JCacheNotifier notifier) {
        ExpirationTrackingInterceptor interceptor = new ExpirationTrackingInterceptor(cache.getDataContainer(), this, notifier, cache.getComponentRegistry().getTimeService());
        cache.addInterceptorBefore((CommandInterceptor)interceptor, EntryWrappingInterceptor.class);
    }

    public Status getStatus() {
        return JStatusConverter.convert(this.cache.getStatus());
    }

    public void start() {
        this.cache.start();
        this.cache.addListener(new JCacheListenerAdapter<K, V>(this, this.notifier));
    }

    public void stop() {
        this.setStatisticsEnabled(false);
        this.setManagementEnabled(false);
        this.cache.stop();
    }

    public void clear() {
        this.skipListenerCache.clear();
    }

    public boolean containsKey(final K key) {
        this.checkStarted();
        if (log.isTraceEnabled()) {
            log.tracef("Invoke containsKey(key=%s)", key);
        }
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.skipCacheLoadCache.containsKey(key);
                }
            });
        }
        return this.skipCacheLoadCache.containsKey(key);
    }

    public V get(final K key) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.doGet(key);
                }
            });
        }
        return this.doGet(key);
    }

    private V doGet(K key) {
        Object value = this.cache.get(key);
        if (value != null) {
            this.updateTTLForAccessed(this.cache, new JCacheEntry<K, Object>(key, value));
        }
        return (V)value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkStarted();
        this.verifyKeys(keys);
        if (keys.isEmpty()) {
            return InfinispanCollections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public V getAndPut(final K key, final V value) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.put(JCache.this.cache, JCache.this.cache, key, value, false);
                }
            });
        }
        return this.put(this.cache, this.cache, key, value, false);
    }

    public V getAndRemove(final K key) {
        this.checkStarted();
        this.skipCacheLoadCache.get(key);
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.skipCacheLoadCache.remove(key);
                }
            });
        }
        return (V)this.skipCacheLoadCache.remove(key);
    }

    public V getAndReplace(final K key, final V value) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, value);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, value);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Configuration<K, V> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invokeEntryProcessor(final K key, final Cache.EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) {
        this.checkStarted();
        this.verifyKey(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry processor cannot be null");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Invoke entry processor %s for key=%s", entryProcessor, key);
        }
        return (T)new WithProcessorLock().call(key, new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object oldValue;
                Object safeOldValue = oldValue = JCache.this.skipCacheLoadCache.get(key);
                if (JCache.this.configuration.isStoreByValue()) {
                    safeOldValue = JCache.this.safeCopy(oldValue);
                }
                MutableJCacheEntry<Object, Object> mutable = new MutableJCacheEntry<Object, Object>(JCache.this.cache, key, safeOldValue);
                Object ret = entryProcessor.process(mutable, arguments);
                if (mutable.isRemoved()) {
                    JCache.this.cache.remove(key);
                } else {
                    Object newValue = mutable.getNewValue();
                    if (newValue != null) {
                        if (oldValue != null) {
                            JCache.this.cache.replace(key, oldValue, newValue);
                        } else {
                            JCache.this.cache.putIfAbsent(key, newValue);
                        }
                    }
                }
                return ret;
            }
        });
    }

    private V safeCopy(V original) {
        try {
            StreamingMarshaller marshaller = this.skipCacheLoadCache.getComponentRegistry().getCacheMarshaller();
            byte[] bytes = marshaller.objectToByteBuffer(original);
            Object o = marshaller.objectFromByteBuffer(bytes);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + original, (Throwable)e);
        }
    }

    private boolean lockRequired(K key) {
        boolean locked = this.processorLocks.isLocked(key);
        if (log.isTraceEnabled()) {
            log.tracef("Lock required for key=%s? %s", key, locked);
        }
        return locked;
    }

    private void acquiredProcessorLock(K key) throws InterruptedException {
        this.processorLocks.acquireLock((Object)Thread.currentThread(), key, this.lockTimeout, TimeUnit.MILLISECONDS);
    }

    private void releaseProcessorLock(K key) {
        this.processorLocks.releaseLock((Object)Thread.currentThread(), key);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkStarted();
        return new Itr();
    }

    public void loadAll(Iterable<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        this.checkStarted();
        if (keys == null) {
            throw new NullPointerException("Keys is null");
        }
        if (this.cacheLoader == null) {
            return;
        }
        ArrayList<K> keysToLoad = new ArrayList<K>();
        for (K key : keys) {
            if (key == null) {
                this.setListenerException(listener, new NullPointerException("Key cannot be null"));
                return;
            }
            if (this.skipCacheLoadCache.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        try {
            Map loaded = this.cacheLoader.loadAll(keysToLoad);
            NotifyingFuture future = this.cache.putAllAsync(loaded);
            future.get();
            listener.onCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            listener.onException((Exception)e);
        }
        catch (ExecutionException e) {
            this.setListenerException(listener, e.getCause());
        }
        catch (Throwable t) {
            this.setListenerException(listener, t);
        }
    }

    private void setListenerException(CompletionListener listener, Throwable t) {
        if (t instanceof Exception) {
            listener.onException((Exception)t);
        } else {
            listener.onException((Exception)new CacheException(t));
        }
    }

    public void put(final K key, final V value) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                @Override
                public Void call() {
                    JCache.this.doPut(key, value);
                    return null;
                }
            });
        } else {
            this.doPut(key, value);
        }
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkStarted();
        if (inputMap == null || inputMap.containsKey(null) || inputMap.containsValue(null)) {
            throw new NullPointerException("inputMap is null or keys/values contain a null entry: " + inputMap);
        }
        for (final Map.Entry<K, V> e : inputMap.entrySet()) {
            final K key = e.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.doPut(key, e.getValue());
                        return null;
                    }
                });
                continue;
            }
            this.doPut(key, e.getValue());
        }
    }

    private void doPut(K key, V value) {
        this.put(this.ignoreReturnValuesCache, this.skipCacheLoadAndStatsCache, key, value, false);
    }

    public boolean putIfAbsent(final K key, final V value) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.put(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadCache, key, value, true) == null;
                }
            });
        }
        return this.put(this.skipCacheLoadCache, this.skipCacheLoadCache, key, value, true) == null;
    }

    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener, boolean requireOldValue, CacheEntryEventFilter<? super K, ? super V> cacheEntryFilter, boolean synchronous) {
        if (cacheEntryListener == null) {
            throw new CacheEntryListenerException("A listener may not be null");
        }
        return this.notifier.addListenerIfAbsent(new JCacheListenerRegistration<K, V>(cacheEntryListener, cacheEntryFilter, requireOldValue, synchronous));
    }

    public boolean remove(final K key) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key) != null;
                }
            });
        }
        return this.cache.remove(key) != null;
    }

    public boolean remove(final K key, final V oldValue) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key, oldValue);
                }
            });
        }
        return this.cache.remove(key, oldValue);
    }

    public void removeAll() {
        this.checkStarted();
        ArrayList<NotifyingFuture> futures = new ArrayList<NotifyingFuture>();
        Iterator<Object> i$ = this.iterator();
        while (i$.hasNext()) {
            Cache.Entry<K, V> entry = i$.next();
            final Object key = entry.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.cache.remove(key);
                        return null;
                    }
                });
                continue;
            }
            futures.add(this.cache.removeAsync(key));
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted while waiting for remove to complete");
            }
            catch (Exception e) {
                throw new CacheException("Removing all entries from cache failed", (Throwable)e);
            }
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkStarted();
        this.verifyKeys(keys);
        for (K k : keys) {
            this.remove(k);
        }
    }

    public boolean replace(final K key, final V value) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, null, value, false);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, null, value, false);
    }

    public boolean replace(final K key, final V oldValue, final V newValue) {
        this.checkStarted();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, oldValue, newValue, true);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, oldValue, newValue, true);
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> cacheEntryListener) {
        return cacheEntryListener != null && this.notifier.removeListener(cacheEntryListener);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to type " + clazz + " failed ");
    }

    void setManagementEnabled(boolean enabled) {
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            this.cache.getStats().setStatisticsEnabled(enabled);
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
            this.cache.getStats().setStatisticsEnabled(enabled);
        }
    }

    CacheMXBean getCacheMXBean() {
        return this.mxBean;
    }

    CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.stats;
    }

    MBeanServer getMBeanServer() {
        return JmxUtil.lookupMBeanServer((GlobalConfiguration)this.cache.getCacheManager().getCacheManagerConfiguration());
    }

    private void checkStarted() {
        if (!this.getStatus().equals((Object)Status.STARTED)) {
            throw new IllegalStateException("Cache is in " + this.getStatus() + " state");
        }
    }

    private void verifyKeys(Set<? extends K> keys) {
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("keys is null or keys contains a null: " + keys);
        }
    }

    private void verifyKey(K key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
    }

    private void verifyNewValue(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("New value cannot be null");
        }
    }

    private void verifyOldValue(V oldValue) {
        if (oldValue == null) {
            throw new NullPointerException("Old value cannot be null");
        }
    }

    private V put(AdvancedCache<K, V> cache, AdvancedCache<K, V> createCheckCache, K key, V value, boolean isPutIfAbsent) {
        Object ret;
        boolean isCreated = !createCheckCache.containsKey(key);
        JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
        Configuration.Duration ttl = isCreated ? this.expiryPolicy.getTTLForCreatedEntry(entry) : this.expiryPolicy.getTTLForModifiedEntry(entry, null);
        if (ttl == null || ttl.isEternal()) {
            ret = isPutIfAbsent ? cache.putIfAbsent(key, value) : cache.put(key, value);
        } else if (ttl.equals((Object)Configuration.Duration.ZERO)) {
            ret = !isCreated ? cache.remove(key) : null;
        } else {
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            ret = isPutIfAbsent ? cache.putIfAbsent(key, value, duration, timeUnit) : cache.put(key, value, duration, timeUnit);
        }
        return (V)ret;
    }

    private boolean replace(AdvancedCache<K, V> cache, K key, V oldValue, V value, boolean isConditional) {
        boolean exists = cache.containsKey(key);
        if (exists) {
            JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
            Configuration.Duration ttl = this.expiryPolicy.getTTLForModifiedEntry(entry, null);
            if (ttl == null || ttl.isEternal()) {
                return isConditional ? cache.replace(key, oldValue, value) : cache.replace(key, value) != null;
            }
            if (ttl.equals((Object)Configuration.Duration.ZERO)) {
                return cache.remove(key) != null;
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return isConditional ? cache.replace(key, oldValue, value, duration, timeUnit) : cache.replace(key, value, duration, timeUnit) != null;
        }
        if (isConditional) {
            this.verifyOldValue(oldValue);
        }
        this.verifyNewValue(value);
        return false;
    }

    private V replace(AdvancedCache<K, V> cache, K key, V value) {
        boolean exists = cache.containsKey(key);
        if (exists) {
            JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
            Configuration.Duration ttl = this.expiryPolicy.getTTLForModifiedEntry(entry, null);
            if (ttl == null || ttl.isEternal()) {
                return (V)cache.replace(key, value);
            }
            if (ttl.equals((Object)Configuration.Duration.ZERO)) {
                return (V)cache.remove(key);
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return (V)cache.replace(key, value, duration, timeUnit);
        }
        this.verifyNewValue(value);
        return null;
    }

    private void updateTTLForAccessed(AdvancedCache<K, V> cache, Cache.Entry<K, V> entry) {
        Configuration.Duration ttl = this.expiryPolicy.getTTLForAccessedEntry(entry, null);
        if (ttl != null) {
            if (ttl.equals((Object)Configuration.Duration.ZERO)) {
                cache.remove(entry.getKey());
            } else {
                long durationAmount = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                cache.put(entry.getKey(), entry.getValue(), durationAmount, timeUnit);
            }
        }
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.entrySet().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            if (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                this.next = new JCacheEntry(entry.getKey(), entry.getValue());
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed(JCache.this.cache, this.next);
            this.current = this.next;
            this.fetchNext();
            JCache.this.cache.get(ret.getKey());
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
        }
    }

    private class WithProcessorLock<V> {
        private WithProcessorLock() {
        }

        public V call(K key, Callable<V> callable) {
            try {
                JCache.this.acquiredProcessorLock(key);
                V v = callable.call();
                return v;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                V v = null;
                return v;
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
            finally {
                JCache.this.releaseProcessorLock(key);
            }
        }
    }
}

