/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation.solder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.infinispan.jcache.annotation.solder.AnnotatedConstructorImpl;
import org.infinispan.jcache.annotation.solder.AnnotatedFieldImpl;
import org.infinispan.jcache.annotation.solder.AnnotatedImpl;
import org.infinispan.jcache.annotation.solder.AnnotatedMethodImpl;
import org.infinispan.jcache.annotation.solder.AnnotationStore;

class AnnotatedTypeImpl<X>
extends AnnotatedImpl
implements AnnotatedType<X> {
    private final Set<AnnotatedConstructor<X>> constructors;
    private final Set<AnnotatedField<? super X>> fields;
    private final Set<AnnotatedMethod<? super X>> methods;
    private final Class<X> javaClass;

    AnnotatedTypeImpl(Class<X> clazz, AnnotationStore typeAnnotations, Map<Field, AnnotationStore> fieldAnnotations, Map<Method, AnnotationStore> methodAnnotations, Map<Method, Map<Integer, AnnotationStore>> methodParameterAnnotations, Map<Constructor<?>, AnnotationStore> constructorAnnotations, Map<Constructor<?>, Map<Integer, AnnotationStore>> constructorParameterAnnotations, Map<Field, Type> fieldTypes, Map<Method, Map<Integer, Type>> methodParameterTypes, Map<Constructor<?>, Map<Integer, Type>> constructorParameterTypes) {
        super(clazz, typeAnnotations, null, null);
        this.javaClass = clazz;
        this.constructors = new HashSet<AnnotatedConstructor<X>>();
        HashSet cset = new HashSet();
        HashSet<Executable> mset = new HashSet<Executable>();
        HashSet<AccessibleObject> fset = new HashSet<AccessibleObject>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            AnnotatedConstructorImpl nc = new AnnotatedConstructorImpl(this, constructor, constructorAnnotations.get(constructor), constructorParameterAnnotations.get(constructor), constructorParameterTypes.get(constructor));
            this.constructors.add(nc);
            cset.add(constructor);
        }
        for (Map.Entry<Constructor<?>, AnnotationStore> entry : constructorAnnotations.entrySet()) {
            if (cset.contains(entry.getKey())) continue;
            AnnotatedConstructorImpl nc = new AnnotatedConstructorImpl(this, entry.getKey(), entry.getValue(), constructorParameterAnnotations.get(entry.getKey()), constructorParameterTypes.get(entry.getKey()));
            this.constructors.add(nc);
        }
        this.methods = new HashSet<AnnotatedMethod<? super X>>();
        for (Executable executable : clazz.getMethods()) {
            if (((Method)executable).getDeclaringClass().equals(Object.class)) continue;
            AnnotatedMethodImpl met = new AnnotatedMethodImpl(this, (Method)executable, methodAnnotations.get(executable), methodParameterAnnotations.get(executable), methodParameterTypes.get(executable));
            this.methods.add(met);
            mset.add(executable);
        }
        for (Map.Entry<Executable, AnnotationStore> entry : methodAnnotations.entrySet()) {
            if (((Method)entry.getKey()).getDeclaringClass().equals(Object.class) || mset.contains(entry.getKey())) continue;
            AnnotatedMethodImpl nc = new AnnotatedMethodImpl(this, (Method)entry.getKey(), entry.getValue(), methodParameterAnnotations.get(entry.getKey()), methodParameterTypes.get(entry.getKey()));
            this.methods.add(nc);
        }
        this.fields = new HashSet<AnnotatedField<? super X>>();
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            AnnotatedFieldImpl b = new AnnotatedFieldImpl(this, (Field)accessibleObject, fieldAnnotations.get(accessibleObject), fieldTypes.get(accessibleObject));
            this.fields.add(b);
            fset.add(accessibleObject);
        }
        for (Map.Entry<AccessibleObject, AnnotationStore> entry : fieldAnnotations.entrySet()) {
            if (fset.contains(entry.getKey())) continue;
            this.fields.add(new AnnotatedFieldImpl(this, (Field)entry.getKey(), entry.getValue(), fieldTypes.get(entry.getKey())));
        }
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }
}

