/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation.solder;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class AnnotationStore {
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final Set<Annotation> annotationSet;

    AnnotationStore(Map<Class<? extends Annotation>, Annotation> annotationMap, Set<Annotation> annotationSet) {
        this.annotationMap = annotationMap;
        this.annotationSet = Collections.unmodifiableSet(annotationSet);
    }

    AnnotationStore() {
        this.annotationMap = Collections.emptyMap();
        this.annotationSet = Collections.emptySet();
    }

    <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    Set<Annotation> getAnnotations() {
        return this.annotationSet;
    }

    boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }
}

