/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.jcache.JCache;

public final class RIMBeanServerRegistrationUtility {
    private RIMBeanServerRegistrationUtility() {
    }

    static <K, V> void registerCacheObject(JCache<K, V> cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        ObjectName registeredObjectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        try {
            if (objectNameType.equals((Object)ObjectNameType.CONFIGURATION)) {
                if (!RIMBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                    mBeanServer.registerMBean(cache.getCacheMXBean(), registeredObjectName);
                }
            } else if (objectNameType.equals((Object)ObjectNameType.STATISTICS) && !RIMBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                mBeanServer.registerMBean(cache.getCacheStatisticsMXBean(), registeredObjectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    static <K, V> boolean isRegistered(JCache<K, V> cache, ObjectNameType objectNameType) {
        ObjectName objectName;
        MBeanServer mBeanServer = cache.getMBeanServer();
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType), null);
        return !registeredObjectNames.isEmpty();
    }

    static void unregisterCacheObject(JCache cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = cache.getMBeanServer();
        ObjectName objectName = RIMBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static ObjectName calculateObjectName(Cache cache, ObjectNameType objectNameType) {
        String cacheManagerName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getCacheManager().getURI().toString());
        String cacheName = RIMBeanServerRegistrationUtility.mbeanSafe(cache.getName());
        try {
            return new ObjectName("javax.cache:type=Cache" + objectNameType.objectName + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(",|:|=|\n", ".");
    }

    static enum ObjectNameType {
        STATISTICS("Statistics"),
        CONFIGURATION("Configuration");

        private final String objectName;

        private ObjectNameType(String objectName) {
            this.objectName = objectName;
        }
    }
}

