/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.interceptor;

import javax.cache.Cache;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jcache.JCacheNotifier;
import org.infinispan.util.TimeService;

public class ExpirationTrackingInterceptor
extends CommandInterceptor {
    private final DataContainer container;
    private final Cache<Object, Object> cache;
    private final JCacheNotifier<Object, Object> notifier;
    private final TimeService timeService;

    public ExpirationTrackingInterceptor(DataContainer container, Cache<?, ?> cache, JCacheNotifier<?, ?> notifier, TimeService timeService) {
        this.container = container;
        this.timeService = timeService;
        this.cache = cache;
        this.notifier = notifier;
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        InternalCacheEntry entry = this.container.peek(key);
        if (entry != null && entry.canExpire() && entry.isExpired(this.timeService.wallClockTime())) {
            this.notifier.notifyEntryExpired(this.cache, key, entry.getValue());
        }
        return super.visitGetKeyValueCommand(ctx, command);
    }
}

