/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.integration.CacheLoader;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.jcache.logging.Log;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.spi.AbstractCacheStore;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

public class JCacheLoaderAdapter<K, V>
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(JCacheLoaderAdapter.class, Log.class);
    private CacheLoader<K, V> delegate;

    public void setCacheLoader(CacheLoader<K, V> delegate) {
        this.delegate = delegate;
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        Cache.Entry e = this.delegate.load(key);
        return e == null ? null : new ImmortalCacheEntry(e.getKey(), e.getValue());
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return Collections.emptySet();
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return Collections.emptySet();
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return Collections.emptySet();
    }

    public void start() throws CacheLoaderException {
    }

    public void stop() throws CacheLoaderException {
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        log.trace("Ignoring store invocation");
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        log.trace("Ignoring writing contents of stream to store");
    }

    public void clear() throws CacheLoaderException {
        log.trace("Ignoring clear invocation");
    }

    public boolean remove(Object key) throws CacheLoaderException {
        log.trace("Ignoring removal of key");
        return false;
    }

    public void purgeExpired() {
        log.trace("Ignoring purge expired invocation");
    }

    public void commit(GlobalTransaction tx) {
        log.trace("Ignoring transactional commit call");
    }

    public void rollback(GlobalTransaction tx) {
        log.trace("Ignoring transactional rollback call");
    }

    public void prepare(List<? extends Modification> list, GlobalTransaction tx, boolean isOnePhase) {
        log.trace("Ignoring transactional prepare call");
    }

    protected void purgeInternal() throws CacheLoaderException {
    }
}

